/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math4.distribution.EnumeratedDistribution;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.NotANumberException;
import org.apache.commons.math4.exception.NotFiniteNumberException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.util.Pair;
import org.apache.commons.rng.UniformRandomProvider;

public class EnumeratedRealDistribution
implements ContinuousDistribution,
Serializable {
    private static final long serialVersionUID = 20160311L;
    protected final EnumeratedDistribution<Double> innerDistribution;

    public EnumeratedRealDistribution(double[] dArray, double[] dArray2) throws DimensionMismatchException, NotPositiveException, MathArithmeticException, NotFiniteNumberException, NotANumberException {
        this.innerDistribution = new EnumeratedDistribution(EnumeratedRealDistribution.createDistribution(dArray, dArray2));
    }

    public EnumeratedRealDistribution(double[] dArray) {
        HashMap<Double, Integer> hashMap = new HashMap<Double, Integer>();
        for (double d : dArray) {
            Integer n = (Integer)hashMap.get(d);
            if (n == null) {
                n = 0;
            }
            n = n + 1;
            hashMap.put(d, n);
        }
        int n = hashMap.size();
        double d = dArray.length;
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n2 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            dArray2[n2] = (Double)entry.getKey();
            dArray3[n2] = (double)((Integer)entry.getValue()).intValue() / d;
            ++n2;
        }
        this.innerDistribution = new EnumeratedDistribution(EnumeratedRealDistribution.createDistribution(dArray2, dArray3));
    }

    private static List<Pair<Double, Double>> createDistribution(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray2.length, dArray.length);
        }
        ArrayList<Pair<Double, Double>> arrayList = new ArrayList<Pair<Double, Double>>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(new Pair<Double, Double>(dArray[i], dArray2[i]));
        }
        return arrayList;
    }

    @Override
    public double probability(double d) {
        return this.innerDistribution.probability(d);
    }

    @Override
    public double density(double d) {
        return this.probability(d);
    }

    @Override
    public double cumulativeProbability(double d) {
        double d2 = 0.0;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            if (!(pair.getKey() <= d)) continue;
            d2 += pair.getValue().doubleValue();
        }
        return d2;
    }

    @Override
    public double inverseCumulativeProbability(double d) throws OutOfRangeException {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        double d2 = 0.0;
        double d3 = this.getSupportLowerBound();
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            if (pair.getValue() == 0.0) continue;
            d2 += pair.getValue().doubleValue();
            d3 = pair.getKey();
            if (!(d2 >= d)) continue;
            break;
        }
        return d3;
    }

    @Override
    public double getMean() {
        double d = 0.0;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            d += pair.getValue() * pair.getKey();
        }
        return d;
    }

    @Override
    public double getVariance() {
        double d = 0.0;
        double d2 = 0.0;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            d += pair.getValue() * pair.getKey();
            d2 += pair.getValue() * pair.getKey() * pair.getKey();
        }
        return d2 - d * d;
    }

    @Override
    public double getSupportLowerBound() {
        double d = Double.POSITIVE_INFINITY;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            if (!(pair.getKey() < d) || !(pair.getValue() > 0.0)) continue;
            d = pair.getKey();
        }
        return d;
    }

    @Override
    public double getSupportUpperBound() {
        double d = Double.NEGATIVE_INFINITY;
        for (Pair<Double, Double> pair : this.innerDistribution.getPmf()) {
            if (!(pair.getKey() > d) || !(pair.getValue() > 0.0)) continue;
            d = pair.getKey();
        }
        return d;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new ContinuousDistribution.Sampler(){
            private final EnumeratedDistribution.Sampler inner;
            {
                this.inner = EnumeratedRealDistribution.this.innerDistribution.createSampler(uniformRandomProvider);
            }

            @Override
            public double sample() {
                return (Double)this.inner.sample();
            }
        };
    }
}

