/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.random;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.math4.exception.MathInternalError;
import org.apache.commons.math4.exception.MathParseException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.random.RandomVectorGenerator;
import org.apache.commons.math4.util.FastMath;

public class SobolSequenceGenerator
implements RandomVectorGenerator {
    private static final int BITS = 52;
    private static final double SCALE = FastMath.pow(2.0, 52);
    private static final int MAX_DIMENSION = 1000;
    private static final String RESOURCE_NAME = "/assets/org/apache/commons/math4/random/new-joe-kuo-6.1000";
    private static final String FILE_CHARSET = "US-ASCII";
    private final int dimension;
    private int count = 0;
    private final long[][] direction;
    private final long[] x;

    public SobolSequenceGenerator(int n) throws OutOfRangeException {
        if (n < 1 || n > 1000) {
            throw new OutOfRangeException(n, (Number)1, 1000);
        }
        InputStream inputStream = this.getClass().getResourceAsStream(RESOURCE_NAME);
        if (inputStream == null) {
            throw new MathInternalError();
        }
        this.dimension = n;
        this.direction = new long[n][53];
        this.x = new long[n];
        try {
            this.initFromStream(inputStream);
        }
        catch (IOException iOException) {
            throw new MathInternalError();
        }
        catch (MathParseException mathParseException) {
            throw new MathInternalError();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public SobolSequenceGenerator(int n, InputStream inputStream) throws NotStrictlyPositiveException, MathParseException, IOException {
        if (n < 1) {
            throw new NotStrictlyPositiveException(n);
        }
        this.dimension = n;
        this.direction = new long[n][53];
        this.x = new long[n];
        int n2 = this.initFromStream(inputStream);
        if (n2 < n) {
            throw new OutOfRangeException(n, (Number)1, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int initFromStream(InputStream inputStream) throws MathParseException, IOException {
        for (int i = 1; i <= 52; ++i) {
            this.direction[0][i] = 1L << 52 - i;
        }
        Charset charset = Charset.forName(FILE_CHARSET);
        int n = -1;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, charset));){
            bufferedReader.readLine();
            int n2 = 2;
            int n3 = 1;
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                try {
                    int n4;
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    if (n >= 2 && n <= this.dimension) {
                        n4 = Integer.parseInt(stringTokenizer.nextToken());
                        int n5 = Integer.parseInt(stringTokenizer.nextToken());
                        int[] nArray = new int[n4 + 1];
                        for (int i = 1; i <= n4; ++i) {
                            nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        this.initDirectionVector(n3++, n5, nArray);
                    }
                    if (n > this.dimension) {
                        n4 = n;
                        return n4;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new MathParseException(string, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MathParseException(string, n2);
                }
                ++n2;
            }
        }
        return n;
    }

    private void initDirectionVector(int n, int n2, int[] nArray) {
        int n3;
        int n4 = nArray.length - 1;
        for (n3 = 1; n3 <= n4; ++n3) {
            this.direction[n][n3] = (long)nArray[n3] << 52 - n3;
        }
        for (n3 = n4 + 1; n3 <= 52; ++n3) {
            this.direction[n][n3] = this.direction[n][n3 - n4] ^ this.direction[n][n3 - n4] >> n4;
            for (int i = 1; i <= n4 - 1; ++i) {
                long[] lArray = this.direction[n];
                int n5 = n3;
                lArray[n5] = lArray[n5] ^ (long)(n2 >> n4 - 1 - i & 1) * this.direction[n][n3 - i];
            }
        }
    }

    @Override
    public double[] nextVector() {
        double[] dArray = new double[this.dimension];
        if (this.count == 0) {
            ++this.count;
            return dArray;
        }
        int n = 1;
        int n2 = this.count - 1;
        while ((n2 & 1) == 1) {
            n2 >>= 1;
            ++n;
        }
        for (int i = 0; i < this.dimension; ++i) {
            int n3 = i;
            this.x[n3] = this.x[n3] ^ this.direction[i][n];
            dArray[i] = (double)this.x[i] / SCALE;
        }
        ++this.count;
        return dArray;
    }

    public double[] skipTo(int n) throws NotPositiveException {
        if (n == 0) {
            Arrays.fill(this.x, 0L);
        } else {
            int n2 = n - 1;
            long l = n2 ^ n2 >> 1;
            for (int i = 0; i < this.dimension; ++i) {
                long l2;
                long l3 = 0L;
                for (int j = 1; j <= 52 && (l2 = l >> j - 1) != 0L; ++j) {
                    long l4 = l2 & 1L;
                    l3 ^= l4 * this.direction[i][j];
                }
                this.x[i] = l3;
            }
        }
        this.count = n;
        return this.nextVector();
    }

    public int getNextIndex() {
        return this.count;
    }
}

