/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.LargeMeanPoissonSampler;
import org.apache.commons.rng.sampling.distribution.SmallMeanPoissonSampler;

public class PoissonSamplerCache {
    private final int minN;
    private final int maxN;
    private final LargeMeanPoissonSampler.LargeMeanPoissonSamplerState[] values;

    public PoissonSamplerCache(double d, double d2) {
        PoissonSamplerCache.checkMeanRange(d, d2);
        if (d2 < 40.0) {
            this.minN = 0;
            this.maxN = 0;
            this.values = null;
        } else {
            this.minN = (int)Math.floor(Math.max(d, 40.0));
            this.maxN = (int)Math.floor(Math.min(d2, 2.147483647E9));
            this.values = new LargeMeanPoissonSampler.LargeMeanPoissonSamplerState[this.maxN - this.minN + 1];
        }
    }

    private PoissonSamplerCache(int n, int n2, LargeMeanPoissonSampler.LargeMeanPoissonSamplerState[] largeMeanPoissonSamplerStateArray) {
        this.minN = n;
        this.maxN = n2;
        this.values = largeMeanPoissonSamplerStateArray;
    }

    private static void checkMeanRange(double d, double d2) {
        if (d2 < d) {
            throw new IllegalArgumentException("Max mean: " + d2 + " < " + d);
        }
    }

    public DiscreteSampler createPoissonSampler(UniformRandomProvider uniformRandomProvider, double d) {
        if (d < 40.0) {
            return new SmallMeanPoissonSampler(uniformRandomProvider, d);
        }
        if (d > (double)this.maxN) {
            return new LargeMeanPoissonSampler(uniformRandomProvider, d);
        }
        int n = (int)Math.floor(d);
        if (n < this.minN) {
            return new LargeMeanPoissonSampler(uniformRandomProvider, d);
        }
        int n2 = n - this.minN;
        LargeMeanPoissonSampler.LargeMeanPoissonSamplerState largeMeanPoissonSamplerState = this.values[n2];
        if (largeMeanPoissonSamplerState == null) {
            LargeMeanPoissonSampler largeMeanPoissonSampler = new LargeMeanPoissonSampler(uniformRandomProvider, d);
            this.values[n2] = largeMeanPoissonSampler.getState();
            return largeMeanPoissonSampler;
        }
        double d2 = d - (double)n;
        return new LargeMeanPoissonSampler(uniformRandomProvider, largeMeanPoissonSamplerState, d2);
    }

    public boolean withinRange(double d) {
        if (d < 40.0) {
            return true;
        }
        int n = (int)Math.floor(d);
        return n <= this.maxN && n >= this.minN;
    }

    public boolean isValidRange() {
        return this.values != null;
    }

    public double getMinMean() {
        return this.minN;
    }

    public double getMaxMean() {
        if (this.isValidRange()) {
            return Math.nextAfter((double)this.maxN + 1.0, -1.0);
        }
        return 0.0;
    }

    public static double getMinimumCachedMean() {
        return 40.0;
    }

    public PoissonSamplerCache withRange(double d, double d2) {
        int n;
        int n2;
        if (this.values == null) {
            return new PoissonSamplerCache(d, d2);
        }
        PoissonSamplerCache.checkMeanRange(d, d2);
        if (d2 < 40.0) {
            return new PoissonSamplerCache(0.0, 0.0);
        }
        int n3 = (int)Math.floor(Math.max(d, 40.0));
        int n4 = (int)Math.floor(d2);
        LargeMeanPoissonSampler.LargeMeanPoissonSamplerState[] largeMeanPoissonSamplerStateArray = new LargeMeanPoissonSampler.LargeMeanPoissonSamplerState[n4 - n3 + 1];
        if (this.minN <= n3) {
            n2 = n3 - this.minN;
            n = 0;
        } else {
            n2 = 0;
            n = this.minN - n3;
        }
        int n5 = Math.min(this.values.length - n2, largeMeanPoissonSamplerStateArray.length - n);
        if (n5 > 0) {
            System.arraycopy(this.values, n2, largeMeanPoissonSamplerStateArray, n, n5);
        }
        return new PoissonSamplerCache(n3, n4, largeMeanPoissonSamplerStateArray);
    }
}

