/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.moment;

import io.virtdata.shaded.oac.statistics.descriptive.moment.FirstMoment;
import java.io.Serializable;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.MathUtils;

public class SecondMoment
extends FirstMoment
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    protected double m2;

    public SecondMoment() {
        this.m2 = Double.NaN;
    }

    public SecondMoment(SecondMoment secondMoment) throws NullArgumentException {
        super(secondMoment);
        this.m2 = secondMoment.m2;
    }

    @Override
    public void increment(double d) {
        if (this.n < 1L) {
            this.m2 = 0.0;
            this.m1 = 0.0;
        }
        super.increment(d);
        this.m2 += ((double)this.n - 1.0) * this.dev * this.nDev;
    }

    @Override
    public void clear() {
        super.clear();
        this.m2 = Double.NaN;
    }

    @Override
    public double getResult() {
        return this.m2;
    }

    @Override
    public SecondMoment copy() {
        SecondMoment secondMoment = new SecondMoment();
        SecondMoment.copy(this, secondMoment);
        return secondMoment;
    }

    public static void copy(SecondMoment secondMoment, SecondMoment secondMoment2) throws NullArgumentException {
        MathUtils.checkNotNull(secondMoment);
        MathUtils.checkNotNull(secondMoment2);
        FirstMoment.copy(secondMoment, secondMoment2);
        secondMoment2.m2 = secondMoment.m2;
    }
}

