/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.GammaDistribution;

public class ChiSquaredDistribution
extends AbstractContinuousDistribution {
    private final GammaDistribution gamma;

    public ChiSquaredDistribution(double d) {
        this.gamma = new GammaDistribution(d / 2.0, 2.0);
    }

    public double getDegreesOfFreedom() {
        return this.gamma.getShape() * 2.0;
    }

    @Override
    public double density(double d) {
        return this.gamma.density(d);
    }

    @Override
    public double logDensity(double d) {
        return this.gamma.logDensity(d);
    }

    @Override
    public double cumulativeProbability(double d) {
        return this.gamma.cumulativeProbability(d);
    }

    @Override
    public double getMean() {
        return this.getDegreesOfFreedom();
    }

    @Override
    public double getVariance() {
        return 2.0 * this.getDegreesOfFreedom();
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

