/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.inference;

import io.virtdata.shaded.oac.statistics.descriptive.StatisticalSummary;
import io.virtdata.shaded.oac.statistics.distribution.ContinuousDistribution;
import io.virtdata.shaded.oac.statistics.inference.ChiSquareTest;
import io.virtdata.shaded.oac.statistics.inference.GTest;
import io.virtdata.shaded.oac.statistics.inference.KolmogorovSmirnovTest;
import io.virtdata.shaded.oac.statistics.inference.OneWayAnova;
import io.virtdata.shaded.oac.statistics.inference.TTest;
import java.util.Collection;
import org.apache.commons.math4.exception.ConvergenceException;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.InsufficientDataException;
import org.apache.commons.math4.exception.MaxCountExceededException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.ZeroException;
import org.apache.commons.rng.UniformRandomProvider;

public class InferenceTestUtils {
    private static final TTest T_TEST = new TTest();
    private static final ChiSquareTest CHI_SQUARE_TEST = new ChiSquareTest();
    private static final OneWayAnova ONE_WAY_ANANOVA = new OneWayAnova();
    private static final GTest G_TEST = new GTest();
    private static final KolmogorovSmirnovTest KS_TEST = new KolmogorovSmirnovTest();

    private InferenceTestUtils() {
    }

    public static double homoscedasticT(double[] dArray, double[] dArray2) throws NullArgumentException, NumberIsTooSmallException {
        return T_TEST.homoscedasticT(dArray, dArray2);
    }

    public static double homoscedasticT(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2) throws NullArgumentException, NumberIsTooSmallException {
        return T_TEST.homoscedasticT(statisticalSummary, statisticalSummary2);
    }

    public static boolean homoscedasticTTest(double[] dArray, double[] dArray2, double d) throws NullArgumentException, NumberIsTooSmallException, OutOfRangeException, MaxCountExceededException {
        return T_TEST.homoscedasticTTest(dArray, dArray2, d);
    }

    public static double homoscedasticTTest(double[] dArray, double[] dArray2) throws NullArgumentException, NumberIsTooSmallException, MaxCountExceededException {
        return T_TEST.homoscedasticTTest(dArray, dArray2);
    }

    public static double homoscedasticTTest(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2) throws NullArgumentException, NumberIsTooSmallException, MaxCountExceededException {
        return T_TEST.homoscedasticTTest(statisticalSummary, statisticalSummary2);
    }

    public static double pairedT(double[] dArray, double[] dArray2) throws NullArgumentException, NoDataException, DimensionMismatchException, NumberIsTooSmallException {
        return T_TEST.pairedT(dArray, dArray2);
    }

    public static boolean pairedTTest(double[] dArray, double[] dArray2, double d) throws NullArgumentException, NoDataException, DimensionMismatchException, NumberIsTooSmallException, OutOfRangeException, MaxCountExceededException {
        return T_TEST.pairedTTest(dArray, dArray2, d);
    }

    public static double pairedTTest(double[] dArray, double[] dArray2) throws NullArgumentException, NoDataException, DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException {
        return T_TEST.pairedTTest(dArray, dArray2);
    }

    public static double t(double d, double[] dArray) throws NullArgumentException, NumberIsTooSmallException {
        return T_TEST.t(d, dArray);
    }

    public static double t(double d, StatisticalSummary statisticalSummary) throws NullArgumentException, NumberIsTooSmallException {
        return T_TEST.t(d, statisticalSummary);
    }

    public static double t(double[] dArray, double[] dArray2) throws NullArgumentException, NumberIsTooSmallException {
        return T_TEST.t(dArray, dArray2);
    }

    public static double t(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2) throws NullArgumentException, NumberIsTooSmallException {
        return T_TEST.t(statisticalSummary, statisticalSummary2);
    }

    public static boolean tTest(double d, double[] dArray, double d2) throws NullArgumentException, NumberIsTooSmallException, OutOfRangeException, MaxCountExceededException {
        return T_TEST.tTest(d, dArray, d2);
    }

    public static double tTest(double d, double[] dArray) throws NullArgumentException, NumberIsTooSmallException, MaxCountExceededException {
        return T_TEST.tTest(d, dArray);
    }

    public static boolean tTest(double d, StatisticalSummary statisticalSummary, double d2) throws NullArgumentException, NumberIsTooSmallException, OutOfRangeException, MaxCountExceededException {
        return T_TEST.tTest(d, statisticalSummary, d2);
    }

    public static double tTest(double d, StatisticalSummary statisticalSummary) throws NullArgumentException, NumberIsTooSmallException, MaxCountExceededException {
        return T_TEST.tTest(d, statisticalSummary);
    }

    public static boolean tTest(double[] dArray, double[] dArray2, double d) throws NullArgumentException, NumberIsTooSmallException, OutOfRangeException, MaxCountExceededException {
        return T_TEST.tTest(dArray, dArray2, d);
    }

    public static double tTest(double[] dArray, double[] dArray2) throws NullArgumentException, NumberIsTooSmallException, MaxCountExceededException {
        return T_TEST.tTest(dArray, dArray2);
    }

    public static boolean tTest(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2, double d) throws NullArgumentException, NumberIsTooSmallException, OutOfRangeException, MaxCountExceededException {
        return T_TEST.tTest(statisticalSummary, statisticalSummary2, d);
    }

    public static double tTest(StatisticalSummary statisticalSummary, StatisticalSummary statisticalSummary2) throws NullArgumentException, NumberIsTooSmallException, MaxCountExceededException {
        return T_TEST.tTest(statisticalSummary, statisticalSummary2);
    }

    public static double chiSquare(double[] dArray, long[] lArray) throws NotPositiveException, NotStrictlyPositiveException, DimensionMismatchException {
        return CHI_SQUARE_TEST.chiSquare(dArray, lArray);
    }

    public static double chiSquare(long[][] lArray) throws NullArgumentException, NotPositiveException, DimensionMismatchException {
        return CHI_SQUARE_TEST.chiSquare(lArray);
    }

    public static boolean chiSquareTest(double[] dArray, long[] lArray, double d) throws NotPositiveException, NotStrictlyPositiveException, DimensionMismatchException, OutOfRangeException, MaxCountExceededException {
        return CHI_SQUARE_TEST.chiSquareTest(dArray, lArray, d);
    }

    public static double chiSquareTest(double[] dArray, long[] lArray) throws NotPositiveException, NotStrictlyPositiveException, DimensionMismatchException, MaxCountExceededException {
        return CHI_SQUARE_TEST.chiSquareTest(dArray, lArray);
    }

    public static boolean chiSquareTest(long[][] lArray, double d) throws NullArgumentException, DimensionMismatchException, NotPositiveException, OutOfRangeException, MaxCountExceededException {
        return CHI_SQUARE_TEST.chiSquareTest(lArray, d);
    }

    public static double chiSquareTest(long[][] lArray) throws NullArgumentException, DimensionMismatchException, NotPositiveException, MaxCountExceededException {
        return CHI_SQUARE_TEST.chiSquareTest(lArray);
    }

    public static double chiSquareDataSetsComparison(long[] lArray, long[] lArray2) throws DimensionMismatchException, NotPositiveException, ZeroException {
        return CHI_SQUARE_TEST.chiSquareDataSetsComparison(lArray, lArray2);
    }

    public static double chiSquareTestDataSetsComparison(long[] lArray, long[] lArray2) throws DimensionMismatchException, NotPositiveException, ZeroException, MaxCountExceededException {
        return CHI_SQUARE_TEST.chiSquareTestDataSetsComparison(lArray, lArray2);
    }

    public static boolean chiSquareTestDataSetsComparison(long[] lArray, long[] lArray2, double d) throws DimensionMismatchException, NotPositiveException, ZeroException, OutOfRangeException, MaxCountExceededException {
        return CHI_SQUARE_TEST.chiSquareTestDataSetsComparison(lArray, lArray2, d);
    }

    public static double oneWayAnovaFValue(Collection<double[]> collection) throws NullArgumentException, DimensionMismatchException {
        return ONE_WAY_ANANOVA.anovaFValue(collection);
    }

    public static double oneWayAnovaPValue(Collection<double[]> collection) throws NullArgumentException, DimensionMismatchException, ConvergenceException, MaxCountExceededException {
        return ONE_WAY_ANANOVA.anovaPValue(collection);
    }

    public static boolean oneWayAnovaTest(Collection<double[]> collection, double d) throws NullArgumentException, DimensionMismatchException, OutOfRangeException, ConvergenceException, MaxCountExceededException {
        return ONE_WAY_ANANOVA.anovaTest(collection, d);
    }

    public static double g(double[] dArray, long[] lArray) throws NotPositiveException, NotStrictlyPositiveException, DimensionMismatchException {
        return G_TEST.g(dArray, lArray);
    }

    public static double gTest(double[] dArray, long[] lArray) throws NotPositiveException, NotStrictlyPositiveException, DimensionMismatchException, MaxCountExceededException {
        return G_TEST.gTest(dArray, lArray);
    }

    public static double gTestIntrinsic(double[] dArray, long[] lArray) throws NotPositiveException, NotStrictlyPositiveException, DimensionMismatchException, MaxCountExceededException {
        return G_TEST.gTestIntrinsic(dArray, lArray);
    }

    public static boolean gTest(double[] dArray, long[] lArray, double d) throws NotPositiveException, NotStrictlyPositiveException, DimensionMismatchException, OutOfRangeException, MaxCountExceededException {
        return G_TEST.gTest(dArray, lArray, d);
    }

    public static double gDataSetsComparison(long[] lArray, long[] lArray2) throws DimensionMismatchException, NotPositiveException, ZeroException {
        return G_TEST.gDataSetsComparison(lArray, lArray2);
    }

    public static double rootLogLikelihoodRatio(long l, long l2, long l3, long l4) throws DimensionMismatchException, NotPositiveException, ZeroException {
        return G_TEST.rootLogLikelihoodRatio(l, l2, l3, l4);
    }

    public static double gTestDataSetsComparison(long[] lArray, long[] lArray2) throws DimensionMismatchException, NotPositiveException, ZeroException, MaxCountExceededException {
        return G_TEST.gTestDataSetsComparison(lArray, lArray2);
    }

    public static boolean gTestDataSetsComparison(long[] lArray, long[] lArray2, double d) throws DimensionMismatchException, NotPositiveException, ZeroException, OutOfRangeException, MaxCountExceededException {
        return G_TEST.gTestDataSetsComparison(lArray, lArray2, d);
    }

    public static double kolmogorovSmirnovStatistic(ContinuousDistribution continuousDistribution, double[] dArray) throws InsufficientDataException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovStatistic(continuousDistribution, dArray);
    }

    public static double kolmogorovSmirnovTest(ContinuousDistribution continuousDistribution, double[] dArray) throws InsufficientDataException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovTest(continuousDistribution, dArray);
    }

    public static double kolmogorovSmirnovTest(ContinuousDistribution continuousDistribution, double[] dArray, boolean bl) throws InsufficientDataException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovTest(continuousDistribution, dArray, bl);
    }

    public static boolean kolmogorovSmirnovTest(ContinuousDistribution continuousDistribution, double[] dArray, double d) throws InsufficientDataException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovTest(continuousDistribution, dArray, d);
    }

    public static double kolmogorovSmirnovStatistic(double[] dArray, double[] dArray2) throws InsufficientDataException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovStatistic(dArray, dArray2);
    }

    public static double kolmogorovSmirnovTest(double[] dArray, double[] dArray2) throws InsufficientDataException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovTest(dArray, dArray2);
    }

    public static double kolmogorovSmirnovTest(double[] dArray, double[] dArray2, boolean bl) throws InsufficientDataException, NullArgumentException {
        return KS_TEST.kolmogorovSmirnovTest(dArray, dArray2, bl);
    }

    public static double exactP(double d, int n, int n2, boolean bl) {
        return KS_TEST.exactP(d, n2, n, bl);
    }

    public static double approximateP(double d, int n, int n2) {
        return KS_TEST.approximateP(d, n, n2);
    }

    public static double monteCarloP(double d, int n, int n2, boolean bl, int n3, UniformRandomProvider uniformRandomProvider) {
        return KS_TEST.monteCarloP(d, n, n2, bl, n3, uniformRandomProvider);
    }
}

