/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.interpolation;

import org.apache.commons.math4.analysis.interpolation.BicubicInterpolatingFunction;
import org.apache.commons.math4.analysis.interpolation.BivariateGridInterpolator;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.util.MathArrays;

public class BicubicInterpolator
implements BivariateGridInterpolator {
    @Override
    public BicubicInterpolatingFunction interpolate(final double[] dArray, final double[] dArray2, double[][] dArray3) throws NoDataException, DimensionMismatchException, NonMonotonicSequenceException, NumberIsTooSmallException {
        if (dArray.length == 0 || dArray2.length == 0 || dArray3.length == 0) {
            throw new NoDataException();
        }
        if (dArray.length != dArray3.length) {
            throw new DimensionMismatchException(dArray.length, dArray3.length);
        }
        MathArrays.checkOrder(dArray);
        MathArrays.checkOrder(dArray2);
        int n = dArray.length;
        int n2 = dArray2.length;
        double[][] dArray4 = new double[n][n2];
        double[][] dArray5 = new double[n][n2];
        double[][] dArray6 = new double[n][n2];
        for (int i = 1; i < n - 1; ++i) {
            int n3 = i + 1;
            int n4 = i - 1;
            double d = dArray[n3];
            double d2 = dArray[n4];
            double d3 = d - d2;
            for (int j = 1; j < n2 - 1; ++j) {
                int n5 = j + 1;
                int n6 = j - 1;
                double d4 = dArray2[n5];
                double d5 = dArray2[n6];
                double d6 = d4 - d5;
                dArray4[i][j] = (dArray3[n3][j] - dArray3[n4][j]) / d3;
                dArray5[i][j] = (dArray3[i][n5] - dArray3[i][n6]) / d6;
                double d7 = d3 * d6;
                dArray6[i][j] = (dArray3[n3][n5] - dArray3[n3][n6] - dArray3[n4][n5] + dArray3[n4][n6]) / d7;
            }
        }
        return new BicubicInterpolatingFunction(dArray, dArray2, dArray3, dArray4, dArray5, dArray6){

            @Override
            public boolean isValidPoint(double d, double d2) {
                return !(d < dArray[1] || d > dArray[dArray.length - 2] || d2 < dArray2[1]) && !(d2 > dArray2[dArray2.length - 2]);
            }
        };
    }
}

