/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.solvers;

import org.apache.commons.math4.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math4.analysis.solvers.AbstractPolynomialSolver;
import org.apache.commons.math4.exception.NoBracketingException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.TooManyEvaluationsException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.complex.Complex;
import org.apache.commons.numbers.complex.streams.ComplexUtils;

public class LaguerreSolver
extends AbstractPolynomialSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private final ComplexSolver complexSolver = new ComplexSolver();

    public LaguerreSolver() {
        this(1.0E-6);
    }

    public LaguerreSolver(double d) {
        super(d);
    }

    public LaguerreSolver(double d, double d2) {
        super(d, d2);
    }

    public LaguerreSolver(double d, double d2, double d3) {
        super(d, d2, d3);
    }

    @Override
    public double doSolve() throws TooManyEvaluationsException, NumberIsTooLargeException, NoBracketingException {
        double d = this.getMin();
        double d2 = this.getMax();
        double d3 = this.getStartValue();
        double d4 = this.getFunctionValueAccuracy();
        this.verifySequence(d, d3, d2);
        double d5 = this.computeObjectiveValue(d3);
        if (FastMath.abs(d5) <= d4) {
            return d3;
        }
        double d6 = this.computeObjectiveValue(d);
        if (FastMath.abs(d6) <= d4) {
            return d;
        }
        if (d5 * d6 < 0.0) {
            return this.laguerre(d, d3);
        }
        double d7 = this.computeObjectiveValue(d2);
        if (FastMath.abs(d7) <= d4) {
            return d2;
        }
        if (d5 * d7 < 0.0) {
            return this.laguerre(d3, d2);
        }
        throw new NoBracketingException(d, d2, d6, d7);
    }

    private double laguerre(double d, double d2) {
        Complex complex;
        Complex[] complexArray = ComplexUtils.real2Complex(this.getCoefficients());
        Complex complex2 = this.complexSolver.solve(complexArray, complex = Complex.ofCartesian(0.5 * (d + d2), 0.0));
        if (this.complexSolver.isRoot(d, d2, complex2)) {
            return complex2.getReal();
        }
        double d3 = Double.NaN;
        Complex[] complexArray2 = this.complexSolver.solveAll(complexArray, complex);
        for (int i = 0; i < complexArray2.length; ++i) {
            if (!this.complexSolver.isRoot(d, d2, complexArray2[i])) continue;
            d3 = complexArray2[i].getReal();
            break;
        }
        return d3;
    }

    public Complex[] solveAllComplex(double[] dArray, double d) throws NullArgumentException, NoDataException, TooManyEvaluationsException {
        this.setup(Integer.MAX_VALUE, new PolynomialFunction(dArray), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, d);
        return this.complexSolver.solveAll(ComplexUtils.real2Complex(dArray), Complex.ofCartesian(d, 0.0));
    }

    public Complex solveComplex(double[] dArray, double d) throws NullArgumentException, NoDataException, TooManyEvaluationsException {
        this.setup(Integer.MAX_VALUE, new PolynomialFunction(dArray), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, d);
        return this.complexSolver.solve(ComplexUtils.real2Complex(dArray), Complex.ofCartesian(d, 0.0));
    }

    private class ComplexSolver {
        private ComplexSolver() {
        }

        public boolean isRoot(double d, double d2, Complex complex) {
            if (LaguerreSolver.this.isSequence(d, complex.getReal(), d2)) {
                double d3 = FastMath.max(LaguerreSolver.this.getRelativeAccuracy() * complex.abs(), LaguerreSolver.this.getAbsoluteAccuracy());
                return FastMath.abs(complex.getImaginary()) <= d3 || complex.abs() <= LaguerreSolver.this.getFunctionValueAccuracy();
            }
            return false;
        }

        public Complex[] solveAll(Complex[] complexArray, Complex complex) throws NullArgumentException, NoDataException, TooManyEvaluationsException {
            if (complexArray == null) {
                throw new NullArgumentException();
            }
            int n = complexArray.length - 1;
            if (n == 0) {
                throw new NoDataException(LocalizedFormats.POLYNOMIAL);
            }
            Complex[] complexArray2 = new Complex[n + 1];
            for (int i = 0; i <= n; ++i) {
                complexArray2[i] = complexArray[i];
            }
            Complex[] complexArray3 = new Complex[n];
            for (int i = 0; i < n; ++i) {
                Complex[] complexArray4 = new Complex[n - i + 1];
                System.arraycopy(complexArray2, 0, complexArray4, 0, complexArray4.length);
                complexArray3[i] = this.solve(complexArray4, complex);
                Complex complex2 = complexArray2[n - i];
                Complex complex3 = null;
                for (int j = n - i - 1; j >= 0; --j) {
                    complex3 = complexArray2[j];
                    complexArray2[j] = complex2;
                    complex2 = complex3.add(complex2.multiply(complexArray3[i]));
                }
            }
            return complexArray3;
        }

        public Complex solve(Complex[] complexArray, Complex complex) throws NullArgumentException, NoDataException, TooManyEvaluationsException {
            if (complexArray == null) {
                throw new NullArgumentException();
            }
            int n = complexArray.length - 1;
            if (n == 0) {
                throw new NoDataException(LocalizedFormats.POLYNOMIAL);
            }
            double d = LaguerreSolver.this.getAbsoluteAccuracy();
            double d2 = LaguerreSolver.this.getRelativeAccuracy();
            double d3 = LaguerreSolver.this.getFunctionValueAccuracy();
            Complex complex2 = Complex.ofCartesian(n, 0.0);
            Complex complex3 = Complex.ofCartesian(n - 1, 0.0);
            Complex complex4 = complex;
            Complex complex5 = Complex.ofCartesian(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            while (true) {
                Complex complex6;
                Complex complex7 = complexArray[n];
                Complex complex8 = Complex.ZERO;
                Complex complex9 = Complex.ZERO;
                for (int i = n - 1; i >= 0; --i) {
                    complex9 = complex8.add(complex4.multiply(complex9));
                    complex8 = complex7.add(complex4.multiply(complex8));
                    complex7 = complexArray[i].add(complex4.multiply(complex7));
                }
                complex9 = complex9.multiply(Complex.ofCartesian(2.0, 0.0));
                double d4 = FastMath.max(d2 * complex4.abs(), d);
                if (complex4.subtract(complex5).abs() <= d4) {
                    return complex4;
                }
                if (complex7.abs() <= d3) {
                    return complex4;
                }
                Complex complex10 = complex8.divide(complex7);
                Complex complex11 = complex10.multiply(complex10);
                Complex complex12 = complex11.subtract(complex9.divide(complex7));
                Complex complex13 = complex3.multiply(complex2.multiply(complex12).subtract(complex11));
                Complex complex14 = complex13.sqrt();
                Complex complex15 = complex10.add(complex14);
                Complex complex16 = complex10.subtract(complex14);
                Complex complex17 = complex6 = complex15.abs() > complex16.abs() ? complex15 : complex16;
                if (complex6.equals(Complex.ofCartesian(0.0, 0.0))) {
                    complex4 = complex4.add(Complex.ofCartesian(d, d));
                    complex5 = Complex.ofCartesian(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                } else {
                    complex5 = complex4;
                    complex4 = complex4.subtract(complex2.divide(complex6));
                }
                LaguerreSolver.this.incrementEvaluationCount();
            }
        }
    }
}

