/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.linear.RealVector;
import org.apache.commons.math4.linear.RealVectorChangingVisitor;
import org.apache.commons.math4.linear.RealVectorFormat;
import org.apache.commons.math4.linear.RealVectorPreservingVisitor;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;

public class ArrayRealVector
extends RealVector
implements Serializable {
    private static final long serialVersionUID = -1097961340710804027L;
    private static final RealVectorFormat DEFAULT_FORMAT = RealVectorFormat.getInstance();
    private double[] data;

    public ArrayRealVector() {
        this.data = new double[0];
    }

    public ArrayRealVector(int n) {
        this.data = new double[n];
    }

    public ArrayRealVector(int n, double d) {
        this.data = new double[n];
        Arrays.fill(this.data, d);
    }

    public ArrayRealVector(double[] dArray) {
        this.data = (double[])dArray.clone();
    }

    public ArrayRealVector(double[] dArray, boolean bl) throws NullArgumentException {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        this.data = bl ? (double[])dArray.clone() : dArray;
    }

    public ArrayRealVector(double[] dArray, int n, int n2) throws NullArgumentException, NumberIsTooLargeException {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length < n + n2) {
            throw new NumberIsTooLargeException(n + n2, (Number)dArray.length, true);
        }
        this.data = new double[n2];
        System.arraycopy(dArray, n, this.data, 0, n2);
    }

    public ArrayRealVector(Double[] doubleArray) {
        this.data = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            this.data[i] = doubleArray[i];
        }
    }

    public ArrayRealVector(Double[] doubleArray, int n, int n2) throws NullArgumentException, NumberIsTooLargeException {
        if (doubleArray == null) {
            throw new NullArgumentException();
        }
        if (doubleArray.length < n + n2) {
            throw new NumberIsTooLargeException(n + n2, (Number)doubleArray.length, true);
        }
        this.data = new double[n2];
        for (int i = n; i < n + n2; ++i) {
            this.data[i - n] = doubleArray[i];
        }
    }

    public ArrayRealVector(RealVector realVector) throws NullArgumentException {
        if (realVector == null) {
            throw new NullArgumentException();
        }
        this.data = new double[realVector.getDimension()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = realVector.getEntry(i);
        }
    }

    public ArrayRealVector(ArrayRealVector arrayRealVector) throws NullArgumentException {
        this(arrayRealVector, true);
    }

    public ArrayRealVector(ArrayRealVector arrayRealVector, boolean bl) {
        this.data = bl ? (double[])arrayRealVector.data.clone() : arrayRealVector.data;
    }

    public ArrayRealVector(ArrayRealVector arrayRealVector, ArrayRealVector arrayRealVector2) {
        this.data = new double[arrayRealVector.data.length + arrayRealVector2.data.length];
        System.arraycopy(arrayRealVector.data, 0, this.data, 0, arrayRealVector.data.length);
        System.arraycopy(arrayRealVector2.data, 0, this.data, arrayRealVector.data.length, arrayRealVector2.data.length);
    }

    public ArrayRealVector(ArrayRealVector arrayRealVector, RealVector realVector) {
        int n = arrayRealVector.data.length;
        int n2 = realVector.getDimension();
        this.data = new double[n + n2];
        System.arraycopy(arrayRealVector.data, 0, this.data, 0, n);
        for (int i = 0; i < n2; ++i) {
            this.data[n + i] = realVector.getEntry(i);
        }
    }

    public ArrayRealVector(RealVector realVector, ArrayRealVector arrayRealVector) {
        int n = realVector.getDimension();
        int n2 = arrayRealVector.data.length;
        this.data = new double[n + n2];
        for (int i = 0; i < n; ++i) {
            this.data[i] = realVector.getEntry(i);
        }
        System.arraycopy(arrayRealVector.data, 0, this.data, n, n2);
    }

    public ArrayRealVector(ArrayRealVector arrayRealVector, double[] dArray) {
        int n = arrayRealVector.getDimension();
        int n2 = dArray.length;
        this.data = new double[n + n2];
        System.arraycopy(arrayRealVector.data, 0, this.data, 0, n);
        System.arraycopy(dArray, 0, this.data, n, n2);
    }

    public ArrayRealVector(double[] dArray, ArrayRealVector arrayRealVector) {
        int n = dArray.length;
        int n2 = arrayRealVector.getDimension();
        this.data = new double[n + n2];
        System.arraycopy(dArray, 0, this.data, 0, n);
        System.arraycopy(arrayRealVector.data, 0, this.data, n, n2);
    }

    public ArrayRealVector(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = dArray2.length;
        this.data = new double[n + n2];
        System.arraycopy(dArray, 0, this.data, 0, n);
        System.arraycopy(dArray2, 0, this.data, n, n2);
    }

    @Override
    public ArrayRealVector copy() {
        return new ArrayRealVector(this, true);
    }

    @Override
    public ArrayRealVector add(RealVector realVector) throws DimensionMismatchException {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            int n = dArray.length;
            this.checkVectorDimensions(n);
            ArrayRealVector arrayRealVector = new ArrayRealVector(n);
            double[] dArray2 = arrayRealVector.data;
            for (int i = 0; i < n; ++i) {
                dArray2[i] = this.data[i] + dArray[i];
            }
            return arrayRealVector;
        }
        this.checkVectorDimensions(realVector);
        double[] dArray = (double[])this.data.clone();
        Iterator<RealVector.Entry> iterator = realVector.iterator();
        while (iterator.hasNext()) {
            RealVector.Entry entry = iterator.next();
            int n = entry.getIndex();
            dArray[n] = dArray[n] + entry.getValue();
        }
        return new ArrayRealVector(dArray, false);
    }

    @Override
    public ArrayRealVector subtract(RealVector realVector) throws DimensionMismatchException {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            int n = dArray.length;
            this.checkVectorDimensions(n);
            ArrayRealVector arrayRealVector = new ArrayRealVector(n);
            double[] dArray2 = arrayRealVector.data;
            for (int i = 0; i < n; ++i) {
                dArray2[i] = this.data[i] - dArray[i];
            }
            return arrayRealVector;
        }
        this.checkVectorDimensions(realVector);
        double[] dArray = (double[])this.data.clone();
        Iterator<RealVector.Entry> iterator = realVector.iterator();
        while (iterator.hasNext()) {
            RealVector.Entry entry = iterator.next();
            int n = entry.getIndex();
            dArray[n] = dArray[n] - entry.getValue();
        }
        return new ArrayRealVector(dArray, false);
    }

    @Override
    public ArrayRealVector map(UnivariateFunction univariateFunction) {
        return this.copy().mapToSelf(univariateFunction);
    }

    @Override
    public ArrayRealVector mapToSelf(UnivariateFunction univariateFunction) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = univariateFunction.value(this.data[i]);
        }
        return this;
    }

    @Override
    public RealVector mapAddToSelf(double d) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + d;
        }
        return this;
    }

    @Override
    public RealVector mapSubtractToSelf(double d) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - d;
        }
        return this;
    }

    @Override
    public RealVector mapMultiplyToSelf(double d) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = n++;
            this.data[n2] = this.data[n2] * d;
        }
        return this;
    }

    @Override
    public RealVector mapDivideToSelf(double d) {
        int n = 0;
        while (n < this.data.length) {
            int n2 = n++;
            this.data[n2] = this.data[n2] / d;
        }
        return this;
    }

    @Override
    public ArrayRealVector ebeMultiply(RealVector realVector) throws DimensionMismatchException {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            int n = dArray.length;
            this.checkVectorDimensions(n);
            ArrayRealVector arrayRealVector = new ArrayRealVector(n);
            double[] dArray2 = arrayRealVector.data;
            for (int i = 0; i < n; ++i) {
                dArray2[i] = this.data[i] * dArray[i];
            }
            return arrayRealVector;
        }
        this.checkVectorDimensions(realVector);
        double[] dArray = (double[])this.data.clone();
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] * realVector.getEntry(i);
        }
        return new ArrayRealVector(dArray, false);
    }

    @Override
    public ArrayRealVector ebeDivide(RealVector realVector) throws DimensionMismatchException {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            int n = dArray.length;
            this.checkVectorDimensions(n);
            ArrayRealVector arrayRealVector = new ArrayRealVector(n);
            double[] dArray2 = arrayRealVector.data;
            for (int i = 0; i < n; ++i) {
                dArray2[i] = this.data[i] / dArray[i];
            }
            return arrayRealVector;
        }
        this.checkVectorDimensions(realVector);
        double[] dArray = (double[])this.data.clone();
        for (int i = 0; i < this.data.length; ++i) {
            int n = i;
            dArray[n] = dArray[n] / realVector.getEntry(i);
        }
        return new ArrayRealVector(dArray, false);
    }

    public double[] getDataRef() {
        return this.data;
    }

    @Override
    public double dotProduct(RealVector realVector) throws DimensionMismatchException {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            this.checkVectorDimensions(dArray.length);
            double d = 0.0;
            for (int i = 0; i < this.data.length; ++i) {
                d += this.data[i] * dArray[i];
            }
            return d;
        }
        return super.dotProduct(realVector);
    }

    @Override
    public double getNorm() {
        double d = 0.0;
        for (double d2 : this.data) {
            d += d2 * d2;
        }
        return FastMath.sqrt(d);
    }

    @Override
    public double getL1Norm() {
        double d = 0.0;
        for (double d2 : this.data) {
            d += FastMath.abs(d2);
        }
        return d;
    }

    @Override
    public double getLInfNorm() {
        double d = 0.0;
        for (double d2 : this.data) {
            d = FastMath.max(d, FastMath.abs(d2));
        }
        return d;
    }

    @Override
    public double getDistance(RealVector realVector) throws DimensionMismatchException {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            this.checkVectorDimensions(dArray.length);
            double d = 0.0;
            for (int i = 0; i < this.data.length; ++i) {
                double d2 = this.data[i] - dArray[i];
                d += d2 * d2;
            }
            return FastMath.sqrt(d);
        }
        this.checkVectorDimensions(realVector);
        double d = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            double d3 = this.data[i] - realVector.getEntry(i);
            d += d3 * d3;
        }
        return FastMath.sqrt(d);
    }

    @Override
    public double getL1Distance(RealVector realVector) throws DimensionMismatchException {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            this.checkVectorDimensions(dArray.length);
            double d = 0.0;
            for (int i = 0; i < this.data.length; ++i) {
                double d2 = this.data[i] - dArray[i];
                d += FastMath.abs(d2);
            }
            return d;
        }
        this.checkVectorDimensions(realVector);
        double d = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            double d3 = this.data[i] - realVector.getEntry(i);
            d += FastMath.abs(d3);
        }
        return d;
    }

    @Override
    public double getLInfDistance(RealVector realVector) throws DimensionMismatchException {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            this.checkVectorDimensions(dArray.length);
            double d = 0.0;
            for (int i = 0; i < this.data.length; ++i) {
                double d2 = this.data[i] - dArray[i];
                d = FastMath.max(d, FastMath.abs(d2));
            }
            return d;
        }
        this.checkVectorDimensions(realVector);
        double d = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            double d3 = this.data[i] - realVector.getEntry(i);
            d = FastMath.max(d, FastMath.abs(d3));
        }
        return d;
    }

    @Override
    public RealMatrix outerProduct(RealVector realVector) {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            int n = this.data.length;
            int n2 = dArray.length;
            RealMatrix realMatrix = MatrixUtils.createRealMatrix(n, n2);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    realMatrix.setEntry(i, j, this.data[i] * dArray[j]);
                }
            }
            return realMatrix;
        }
        int n = this.data.length;
        int n3 = realVector.getDimension();
        RealMatrix realMatrix = MatrixUtils.createRealMatrix(n, n3);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                realMatrix.setEntry(i, j, this.data[i] * realVector.getEntry(j));
            }
        }
        return realMatrix;
    }

    @Override
    public double getEntry(int n) throws OutOfRangeException {
        try {
            return this.data[n];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n, 0, this.getDimension() - 1);
        }
    }

    @Override
    public int getDimension() {
        return this.data.length;
    }

    @Override
    public RealVector append(RealVector realVector) {
        try {
            return new ArrayRealVector(this, (ArrayRealVector)realVector);
        }
        catch (ClassCastException classCastException) {
            return new ArrayRealVector(this, realVector);
        }
    }

    public ArrayRealVector append(ArrayRealVector arrayRealVector) {
        return new ArrayRealVector(this, arrayRealVector);
    }

    @Override
    public RealVector append(double d) {
        double[] dArray = new double[this.data.length + 1];
        System.arraycopy(this.data, 0, dArray, 0, this.data.length);
        dArray[this.data.length] = d;
        return new ArrayRealVector(dArray, false);
    }

    @Override
    public RealVector getSubVector(int n, int n2) throws OutOfRangeException, NotPositiveException {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, n2);
        }
        ArrayRealVector arrayRealVector = new ArrayRealVector(n2);
        try {
            System.arraycopy(this.data, n, arrayRealVector.data, 0, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.checkIndex(n);
            this.checkIndex(n + n2 - 1);
        }
        return arrayRealVector;
    }

    @Override
    public void setEntry(int n, double d) throws OutOfRangeException {
        try {
            this.data[n] = d;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.checkIndex(n);
        }
    }

    @Override
    public void addToEntry(int n, double d) throws OutOfRangeException {
        try {
            int n2 = n;
            this.data[n2] = this.data[n2] + d;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n, 0, this.data.length - 1);
        }
    }

    @Override
    public void setSubVector(int n, RealVector realVector) throws OutOfRangeException {
        if (realVector instanceof ArrayRealVector) {
            this.setSubVector(n, ((ArrayRealVector)realVector).data);
        } else {
            try {
                for (int i = n; i < n + realVector.getDimension(); ++i) {
                    this.data[i] = realVector.getEntry(i - n);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkIndex(n);
                this.checkIndex(n + realVector.getDimension() - 1);
            }
        }
    }

    public void setSubVector(int n, double[] dArray) throws OutOfRangeException {
        try {
            System.arraycopy(dArray, 0, this.data, n, dArray.length);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.checkIndex(n);
            this.checkIndex(n + dArray.length - 1);
        }
    }

    @Override
    public void set(double d) {
        Arrays.fill(this.data, d);
    }

    @Override
    public double[] toArray() {
        return (double[])this.data.clone();
    }

    public String toString() {
        return DEFAULT_FORMAT.format(this);
    }

    @Override
    protected void checkVectorDimensions(RealVector realVector) throws DimensionMismatchException {
        this.checkVectorDimensions(realVector.getDimension());
    }

    @Override
    protected void checkVectorDimensions(int n) throws DimensionMismatchException {
        if (this.data.length != n) {
            throw new DimensionMismatchException(this.data.length, n);
        }
    }

    @Override
    public boolean isNaN() {
        for (double d : this.data) {
            if (!Double.isNaN(d)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInfinite() {
        if (this.isNaN()) {
            return false;
        }
        for (double d : this.data) {
            if (!Double.isInfinite(d)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RealVector)) {
            return false;
        }
        RealVector realVector = (RealVector)object;
        if (this.data.length != realVector.getDimension()) {
            return false;
        }
        if (realVector.isNaN()) {
            return this.isNaN();
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == realVector.getEntry(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.isNaN()) {
            return 9;
        }
        return MathUtils.hash(this.data);
    }

    @Override
    public ArrayRealVector combine(double d, double d2, RealVector realVector) throws DimensionMismatchException {
        return this.copy().combineToSelf(d, d2, realVector);
    }

    @Override
    public ArrayRealVector combineToSelf(double d, double d2, RealVector realVector) throws DimensionMismatchException {
        if (realVector instanceof ArrayRealVector) {
            double[] dArray = ((ArrayRealVector)realVector).data;
            this.checkVectorDimensions(dArray.length);
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = d * this.data[i] + d2 * dArray[i];
            }
        } else {
            this.checkVectorDimensions(realVector);
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = d * this.data[i] + d2 * realVector.getEntry(i);
            }
        }
        return this;
    }

    @Override
    public double walkInDefaultOrder(RealVectorPreservingVisitor realVectorPreservingVisitor) {
        realVectorPreservingVisitor.start(this.data.length, 0, this.data.length - 1);
        for (int i = 0; i < this.data.length; ++i) {
            realVectorPreservingVisitor.visit(i, this.data[i]);
        }
        return realVectorPreservingVisitor.end();
    }

    @Override
    public double walkInDefaultOrder(RealVectorPreservingVisitor realVectorPreservingVisitor, int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkIndices(n, n2);
        realVectorPreservingVisitor.start(this.data.length, n, n2);
        for (int i = n; i <= n2; ++i) {
            realVectorPreservingVisitor.visit(i, this.data[i]);
        }
        return realVectorPreservingVisitor.end();
    }

    @Override
    public double walkInOptimizedOrder(RealVectorPreservingVisitor realVectorPreservingVisitor) {
        return this.walkInDefaultOrder(realVectorPreservingVisitor);
    }

    @Override
    public double walkInOptimizedOrder(RealVectorPreservingVisitor realVectorPreservingVisitor, int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInDefaultOrder(realVectorPreservingVisitor, n, n2);
    }

    @Override
    public double walkInDefaultOrder(RealVectorChangingVisitor realVectorChangingVisitor) {
        realVectorChangingVisitor.start(this.data.length, 0, this.data.length - 1);
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = realVectorChangingVisitor.visit(i, this.data[i]);
        }
        return realVectorChangingVisitor.end();
    }

    @Override
    public double walkInDefaultOrder(RealVectorChangingVisitor realVectorChangingVisitor, int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkIndices(n, n2);
        realVectorChangingVisitor.start(this.data.length, n, n2);
        for (int i = n; i <= n2; ++i) {
            this.data[i] = realVectorChangingVisitor.visit(i, this.data[i]);
        }
        return realVectorChangingVisitor.end();
    }

    @Override
    public double walkInOptimizedOrder(RealVectorChangingVisitor realVectorChangingVisitor) {
        return this.walkInDefaultOrder(realVectorChangingVisitor);
    }

    @Override
    public double walkInOptimizedOrder(RealVectorChangingVisitor realVectorChangingVisitor, int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInDefaultOrder(realVectorChangingVisitor, n, n2);
    }
}

