/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import java.util.Arrays;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public abstract class AbstractWell
extends IntProvider {
    private static final int BLOCK_SIZE = 32;
    protected int index;
    protected final int[] v;

    protected AbstractWell(int n, int[] nArray) {
        int n2 = AbstractWell.calculateBlockCount(n);
        this.v = new int[n2];
        this.index = 0;
        this.setSeedInternal(nArray);
    }

    @Override
    protected byte[] getStateInternal() {
        int[] nArray = Arrays.copyOf(this.v, this.v.length + 1);
        nArray[this.v.length] = this.index;
        return this.composeStateInternal(NumberFactory.makeByteArray(nArray), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, (this.v.length + 1) * 4);
        int[] nArray = NumberFactory.makeIntArray(byArray2[0]);
        System.arraycopy(nArray, 0, this.v, 0, this.v.length);
        this.index = nArray[this.v.length];
        super.setStateInternal(byArray2[1]);
    }

    private void setSeedInternal(int[] nArray) {
        System.arraycopy(nArray, 0, this.v, 0, Math.min(nArray.length, this.v.length));
        if (nArray.length < this.v.length) {
            for (int i = nArray.length; i < this.v.length; ++i) {
                long l = this.v[i - nArray.length];
                this.v[i] = (int)(1812433253L * (l ^ l >> 30) + (long)i & 0xFFFFFFFFL);
            }
        }
        this.index = 0;
    }

    private static int calculateBlockCount(int n) {
        return (n + 32 - 1) / 32;
    }

    protected static final class IndexTable {
        private final int[] iRm1;
        private final int[] iRm2;
        private final int[] i1;
        private final int[] i2;
        private final int[] i3;

        public IndexTable(int n, int n2, int n3, int n4) {
            int n5 = AbstractWell.calculateBlockCount(n);
            this.iRm1 = new int[n5];
            this.iRm2 = new int[n5];
            this.i1 = new int[n5];
            this.i2 = new int[n5];
            this.i3 = new int[n5];
            for (int i = 0; i < n5; ++i) {
                this.iRm1[i] = (i + n5 - 1) % n5;
                this.iRm2[i] = (i + n5 - 2) % n5;
                this.i1[i] = (i + n2) % n5;
                this.i2[i] = (i + n3) % n5;
                this.i3[i] = (i + n4) % n5;
            }
        }

        public int getIndexPred(int n) {
            return this.iRm1[n];
        }

        public int getIndexPred2(int n) {
            return this.iRm2[n];
        }

        public int getIndexM1(int n) {
            return this.i1[n];
        }

        public int getIndexM2(int n) {
            return this.i2[n];
        }

        public int getIndexM3(int n) {
            return this.i3[n];
        }
    }
}

