/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import java.util.Arrays;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.util.NumberFactory;

public class ISAACRandom
extends IntProvider {
    private static final int SIZE_L = 8;
    private static final int SIZE = 256;
    private static final int H_SIZE = 128;
    private static final int MASK = 1020;
    private static final int GLD_RATIO = -1640531527;
    private final int[] rsl = new int[256];
    private final int[] mem = new int[256];
    private int count;
    private int isaacA;
    private int isaacB;
    private int isaacC;
    private final int[] arr = new int[8];
    private int isaacX;
    private int isaacI;
    private int isaacJ;

    public ISAACRandom(int[] nArray) {
        this.setSeedInternal(nArray);
    }

    @Override
    protected byte[] getStateInternal() {
        int[] nArray = Arrays.copyOf(this.rsl, 256);
        int[] nArray2 = Arrays.copyOf(this.mem, 256);
        int[] nArray3 = Arrays.copyOf(new int[]{this.count, this.isaacA, this.isaacB, this.isaacC}, 4);
        int[] nArray4 = new int[512 + nArray3.length];
        System.arraycopy(nArray, 0, nArray4, 0, 256);
        System.arraycopy(nArray2, 0, nArray4, 256, 256);
        System.arraycopy(nArray3, 0, nArray4, 512, nArray3.length);
        return this.composeStateInternal(NumberFactory.makeByteArray(nArray4), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, 2064);
        int[] nArray = NumberFactory.makeIntArray(byArray2[0]);
        System.arraycopy(nArray, 0, this.rsl, 0, 256);
        System.arraycopy(nArray, 256, this.mem, 0, 256);
        this.count = nArray[512];
        this.isaacA = nArray[513];
        this.isaacB = nArray[514];
        this.isaacC = nArray[515];
        super.setStateInternal(byArray2[1]);
    }

    private void setSeedInternal(int[] nArray) {
        int n = nArray.length;
        int n2 = this.rsl.length;
        System.arraycopy(nArray, 0, this.rsl, 0, Math.min(n, n2));
        if (n < n2) {
            for (int i = n; i < n2; ++i) {
                long l = this.rsl[i - n];
                this.rsl[i] = (int)(1812433253L * (l ^ l >> 30) + (long)i & 0xFFFFFFFFL);
            }
        }
        this.initState();
    }

    @Override
    public int next() {
        if (this.count < 0) {
            this.isaac();
            this.count = 255;
        }
        return this.rsl[this.count--];
    }

    private void isaac() {
        this.isaacI = 0;
        this.isaacJ = 128;
        this.isaacB += ++this.isaacC;
        while (this.isaacI < 128) {
            this.isaac2();
        }
        this.isaacJ = 0;
        while (this.isaacJ < 128) {
            this.isaac2();
        }
    }

    private void isaac2() {
        this.isaacX = this.mem[this.isaacI];
        this.isaacA ^= this.isaacA << 13;
        this.isaacA += this.mem[this.isaacJ++];
        this.isaac3();
        this.isaacX = this.mem[this.isaacI];
        this.isaacA ^= this.isaacA >>> 6;
        this.isaacA += this.mem[this.isaacJ++];
        this.isaac3();
        this.isaacX = this.mem[this.isaacI];
        this.isaacA ^= this.isaacA << 2;
        this.isaacA += this.mem[this.isaacJ++];
        this.isaac3();
        this.isaacX = this.mem[this.isaacI];
        this.isaacA ^= this.isaacA >>> 16;
        this.isaacA += this.mem[this.isaacJ++];
        this.isaac3();
    }

    private void isaac3() {
        this.mem[this.isaacI] = this.mem[(this.isaacX & 0x3FC) >> 2] + this.isaacA + this.isaacB;
        this.isaacB = this.mem[(this.mem[this.isaacI] >> 8 & 0x3FC) >> 2] + this.isaacX;
        this.rsl[this.isaacI++] = this.isaacB;
    }

    private void initState() {
        int n;
        this.isaacA = 0;
        this.isaacB = 0;
        this.isaacC = 0;
        for (n = 0; n < this.arr.length; ++n) {
            this.arr[n] = -1640531527;
        }
        for (n = 0; n < 4; ++n) {
            this.shuffle();
        }
        for (n = 0; n < 256; n += 8) {
            this.arr[0] = this.arr[0] + this.rsl[n];
            this.arr[1] = this.arr[1] + this.rsl[n + 1];
            this.arr[2] = this.arr[2] + this.rsl[n + 2];
            this.arr[3] = this.arr[3] + this.rsl[n + 3];
            this.arr[4] = this.arr[4] + this.rsl[n + 4];
            this.arr[5] = this.arr[5] + this.rsl[n + 5];
            this.arr[6] = this.arr[6] + this.rsl[n + 6];
            this.arr[7] = this.arr[7] + this.rsl[n + 7];
            this.shuffle();
            this.setState(n);
        }
        for (n = 0; n < 256; n += 8) {
            this.arr[0] = this.arr[0] + this.mem[n];
            this.arr[1] = this.arr[1] + this.mem[n + 1];
            this.arr[2] = this.arr[2] + this.mem[n + 2];
            this.arr[3] = this.arr[3] + this.mem[n + 3];
            this.arr[4] = this.arr[4] + this.mem[n + 4];
            this.arr[5] = this.arr[5] + this.mem[n + 5];
            this.arr[6] = this.arr[6] + this.mem[n + 6];
            this.arr[7] = this.arr[7] + this.mem[n + 7];
            this.shuffle();
            this.setState(n);
        }
        this.isaac();
        this.count = 255;
    }

    private void shuffle() {
        this.arr[0] = this.arr[0] ^ this.arr[1] << 11;
        this.arr[3] = this.arr[3] + this.arr[0];
        this.arr[1] = this.arr[1] + this.arr[2];
        this.arr[1] = this.arr[1] ^ this.arr[2] >>> 2;
        this.arr[4] = this.arr[4] + this.arr[1];
        this.arr[2] = this.arr[2] + this.arr[3];
        this.arr[2] = this.arr[2] ^ this.arr[3] << 8;
        this.arr[5] = this.arr[5] + this.arr[2];
        this.arr[3] = this.arr[3] + this.arr[4];
        this.arr[3] = this.arr[3] ^ this.arr[4] >>> 16;
        this.arr[6] = this.arr[6] + this.arr[3];
        this.arr[4] = this.arr[4] + this.arr[5];
        this.arr[4] = this.arr[4] ^ this.arr[5] << 10;
        this.arr[7] = this.arr[7] + this.arr[4];
        this.arr[5] = this.arr[5] + this.arr[6];
        this.arr[5] = this.arr[5] ^ this.arr[6] >>> 4;
        this.arr[0] = this.arr[0] + this.arr[5];
        this.arr[6] = this.arr[6] + this.arr[7];
        this.arr[6] = this.arr[6] ^ this.arr[7] << 8;
        this.arr[1] = this.arr[1] + this.arr[6];
        this.arr[7] = this.arr[7] + this.arr[0];
        this.arr[7] = this.arr[7] ^ this.arr[0] >>> 9;
        this.arr[2] = this.arr[2] + this.arr[7];
        this.arr[0] = this.arr[0] + this.arr[1];
    }

    private void setState(int n) {
        this.mem[n] = this.arr[0];
        this.mem[n + 1] = this.arr[1];
        this.mem[n + 2] = this.arr[2];
        this.mem[n + 3] = this.arr[3];
        this.mem[n + 4] = this.arr[4];
        this.mem[n + 5] = this.arr[5];
        this.mem[n + 6] = this.arr[6];
        this.mem[n + 7] = this.arr[7];
    }
}

