/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractXoShiRo512
extends LongProvider {
    private static final int SEED_SIZE = 8;
    protected long state0;
    protected long state1;
    protected long state2;
    protected long state3;
    protected long state4;
    protected long state5;
    protected long state6;
    protected long state7;

    AbstractXoShiRo512(long[] lArray) {
        if (lArray.length < 8) {
            long[] lArray2 = new long[8];
            this.fillState(lArray2, lArray);
            this.setState(lArray2);
        } else {
            this.setState(lArray);
        }
    }

    AbstractXoShiRo512(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        this.state0 = l;
        this.state1 = l2;
        this.state2 = l3;
        this.state3 = l4;
        this.state4 = l5;
        this.state5 = l6;
        this.state6 = l7;
        this.state7 = l8;
    }

    private void setState(long[] lArray) {
        this.state0 = lArray[0];
        this.state1 = lArray[1];
        this.state2 = lArray[2];
        this.state3 = lArray[3];
        this.state4 = lArray[4];
        this.state5 = lArray[5];
        this.state6 = lArray[6];
        this.state7 = lArray[7];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.state0, this.state1, this.state2, this.state3, this.state4, this.state5, this.state6, this.state7}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, 64);
        this.setState(NumberFactory.makeLongArray(byArray2[0]));
        super.setStateInternal(byArray2[1]);
    }
}

