/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapper;
import io.virtdata.api.FunctionType;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class DataMapperFunctionMapper {
    public static <T> DataMapper<T> map(Object function) {
        FunctionType functionType = FunctionType.valueOf(function);
        switch (functionType) {
            case long_double: {
                return DataMapperFunctionMapper.map((LongToDoubleFunction)function);
            }
            case long_int: {
                return DataMapperFunctionMapper.map((LongToIntFunction)function);
            }
            case long_long: {
                return DataMapperFunctionMapper.map((LongUnaryOperator)function);
            }
            case long_T: {
                return DataMapperFunctionMapper.map((LongFunction)function);
            }
            case R_T: {
                return DataMapperFunctionMapper.map((Function)function);
            }
            case int_int: {
                return DataMapperFunctionMapper.map((IntUnaryOperator)function);
            }
            case int_long: {
                return DataMapperFunctionMapper.map((IntToLongFunction)function);
            }
            case int_double: {
                return DataMapperFunctionMapper.map((IntToDoubleFunction)function);
            }
            case int_T: {
                return DataMapperFunctionMapper.map((IntFunction)function);
            }
            case double_double: {
                return DataMapperFunctionMapper.map((DoubleUnaryOperator)function);
            }
            case double_long: {
                return DataMapperFunctionMapper.map((DoubleToLongFunction)function);
            }
            case double_int: {
                return DataMapperFunctionMapper.map((DoubleToIntFunction)function);
            }
            case double_T: {
                return DataMapperFunctionMapper.map((DoubleFunction)function);
            }
        }
        throw new RuntimeException("Function object was not a recognized type for mapping to a data mapping lambda: " + function.toString());
    }

    public static <R> DataMapper<R> map(DoubleFunction<R> f) {
        return l -> f.apply(l);
    }

    public static DataMapper<Integer> map(DoubleToIntFunction f) {
        return f::applyAsInt;
    }

    public static DataMapper<Long> map(DoubleToLongFunction f) {
        return f::applyAsLong;
    }

    public static DataMapper<Double> map(DoubleUnaryOperator f) {
        return f::applyAsDouble;
    }

    public static <R> DataMapper<R> map(IntFunction<R> f) {
        return l -> f.apply((int)l);
    }

    public static DataMapper<Long> map(IntToDoubleFunction f) {
        return l -> (long)f.applyAsDouble((int)l);
    }

    public static DataMapper<Long> map(IntToLongFunction f) {
        return l -> f.applyAsLong((int)l);
    }

    public static DataMapper<Integer> map(IntUnaryOperator f) {
        return l -> f.applyAsInt((int)l);
    }

    public static DataMapper<Double> map(LongToDoubleFunction f) {
        return f::applyAsDouble;
    }

    public static DataMapper<Integer> map(LongToIntFunction f) {
        return f::applyAsInt;
    }

    public static DataMapper<Long> map(LongUnaryOperator f) {
        return f::applyAsLong;
    }

    public static <R> DataMapper<R> map(LongFunction<R> f) {
        return f::apply;
    }

    public static <R> DataMapper<R> map(Function<Long, R> f) {
        return f::apply;
    }
}

