/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.templates;

import io.virtdata.api.ValuesBinder;
import io.virtdata.core.Bindings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringCompositor
implements ValuesBinder<StringCompositor, String> {
    private static Pattern tokenPattern = Pattern.compile("(?<section>(?<literal>[^{}]+)?(?<anchor>\\{(?<token>[a-zA-Z0-9-_.]+)?\\})?)");
    private String[] templateSegments;
    private Function<Object, String> stringfunc = String::valueOf;

    public StringCompositor(String template) {
        this.templateSegments = this.parseTemplate(template);
    }

    public StringCompositor(String template, Function<Object, String> stringfunc) {
        this(template);
        this.stringfunc = stringfunc;
    }

    private String[] parseTemplate(String template) {
        Matcher matcher = tokenPattern.matcher(template);
        ArrayList<String> sections = new ArrayList<String>();
        int counter = 0;
        while (matcher.find()) {
            String literal = matcher.group("literal");
            String anchor = matcher.group("anchor");
            String token = matcher.group("token");
            if (anchor == null && literal == null) break;
            sections.add(Optional.ofNullable(literal).orElse(""));
            if (anchor == null) continue;
            sections.add(Optional.ofNullable(token).orElse(String.valueOf(counter++)));
        }
        if (sections.size() % 2 == 0) {
            sections.add("");
        }
        return sections.toArray(new String[0]);
    }

    @Override
    public String bindValues(StringCompositor context, Bindings bindings, long cycle) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.templateSegments.length; ++i) {
            if (i % 2 == 0) {
                sb.append(this.templateSegments[i]);
                continue;
            }
            String key = this.templateSegments[i];
            Object value = bindings.get(key, cycle);
            String valueString = this.stringfunc.apply(value);
            sb.append(valueString);
        }
        return sb.toString();
    }

    public List<String> getBindPointNames() {
        ArrayList<String> tokens = new ArrayList<String>();
        for (int i = 0; i < this.templateSegments.length; ++i) {
            if (i % 2 != 1) continue;
            tokens.add(this.templateSegments[i]);
        }
        return tokens;
    }
}

