/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.random;

import io.virtdata.annotations.DeprecatedFunction;
import java.util.function.LongFunction;
import org.apache.commons.math3.random.MersenneTwister;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomRangedToString
implements LongFunction<String> {
    private final MersenneTwister theTwister;
    private long min;
    private long max;
    private long _length;

    public RandomRangedToString(long min, long max) {
        this(min, max, System.nanoTime());
    }

    public RandomRangedToString(long min, long max, long seed) {
        this.theTwister = new MersenneTwister(seed);
        if (max <= min) {
            throw new RuntimeException("max must be >= min");
        }
        this.min = min;
        this.max = max;
        this._length = max - min;
    }

    @Override
    public String apply(long input) {
        long value = Math.abs(this.theTwister.nextLong());
        value %= this._length;
        return String.valueOf(value += this.min);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.min + ":" + this.max;
    }
}

