/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.templates;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedTemplate {
    private static final Pattern[] DEFAULT_PATTERNS = new Pattern[]{Pattern.compile("\\{(?<anchor>\\w+[-_\\d\\w.]*)}"), Pattern.compile("\\?(?<anchor>\\w+[-_\\d\\w.]*)")};
    private static final Logger logger = LoggerFactory.getLogger(ParsedTemplate.class);
    private final Pattern[] patterns;
    private final String rawtemplate;
    private final String[] spans;
    private final Set<String> missingBindings = new HashSet<String>();
    private final Set<String> extraBindings = new HashSet<String>();
    private final Map<String, String> bindings = new LinkedHashMap<String, String>();
    private final Map<String, String> specificBindings = new LinkedHashMap<String, String>();

    public ParsedTemplate(String rawtemplate, Map<String, String> providedBindings) {
        this(rawtemplate, providedBindings, DEFAULT_PATTERNS);
    }

    public ParsedTemplate(String rawtemplate, Map<String, String> providedBindings, Pattern ... providedPatterns) {
        this.rawtemplate = rawtemplate;
        this.bindings.putAll(providedBindings);
        this.patterns = providedPatterns;
        this.spans = this.parse();
    }

    public ParsedTemplate orError() {
        if (this.hasError()) {
            throw new RuntimeException("Unable to parse statement: " + this.toString());
        }
        return this;
    }

    private String[] parse() {
        ArrayList<String> spans = new ArrayList<String>();
        HashSet<String> usedAnchors = new HashSet<String>();
        this.extraBindings.addAll(this.bindings.keySet());
        String statement = this.rawtemplate;
        boolean patternsMatched = false;
        int lastMatch = 0;
        for (Pattern pattern : this.patterns) {
            if (!pattern.toString().contains("?<anchor>")) {
                throw new InvalidParameterException("The provided pattern '" + pattern.toString() + "' must contain a named group called anchor,as in '(?<anchor>...)'");
            }
            Matcher m = pattern.matcher(this.rawtemplate);
            if (!m.find()) continue;
            while (m.find(lastMatch)) {
                String pre = statement.substring(lastMatch, m.start());
                spans.add(pre);
                String tokenName = m.group("anchor");
                lastMatch = m.end();
                spans.add(tokenName);
                if (this.extraBindings.contains(tokenName)) {
                    usedAnchors.add(tokenName);
                    this.specificBindings.put(tokenName, this.bindings.get(tokenName));
                    continue;
                }
                this.missingBindings.add(tokenName);
            }
            usedAnchors.forEach(this.extraBindings::remove);
            break;
        }
        if (lastMatch >= 0) {
            spans.add(statement.substring(lastMatch));
        } else {
            spans.add(statement);
        }
        return spans.toArray(new String[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("template: '").append(this.rawtemplate).append("'");
        sb.append("\n parsed: ");
        sb.append(StreamSupport.stream(Arrays.spliterator(this.spans), false).map(s -> "[" + s + "]").collect(Collectors.joining(",")));
        sb.append("\n missing bindings: ").append(this.missingBindings.stream().collect(Collectors.joining(",", "[", "]")));
        sb.append(" extra bindings: ");
        sb.append("\n extra bindings: ").append(this.extraBindings.stream().collect(Collectors.joining(",", "[", "]")));
        return sb.toString();
    }

    public boolean hasError() {
        return this.missingBindings.size() > 0;
    }

    public Set<String> getExtraBindings() {
        return this.extraBindings;
    }

    public Set<String> getMissingBindings() {
        return this.missingBindings;
    }

    public Map<String, String> getSpecificBindings() {
        return this.specificBindings;
    }

    public String getPositionalStatement(String anchorToken) {
        StringBuilder sb = new StringBuilder(this.spans[0]);
        for (int i = 1; i < this.spans.length; ++i) {
            sb.append(anchorToken).append(this.spans[i]);
        }
        return sb.toString();
    }

    public String[] getSpans() {
        return this.spans;
    }

    public static class BindPoint {
        String anchor;
        String bindspec;
        ParsedTemplate template;

        public BindPoint(String anchor, String bindspec, ParsedTemplate template) {
            this.anchor = anchor;
            this.bindspec = bindspec;
            this.template = template;
        }

        public String getAnchor() {
            return this.anchor;
        }

        public String getBindspec() {
            return this.bindspec;
        }

        public ParsedTemplate getTemplate() {
            return this.template;
        }
    }
}

