/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.random;

import io.virtdata.annotations.DeprecatedFunction;
import io.virtdata.util.VirtDataResources;
import java.util.List;
import java.util.function.LongToIntFunction;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomLineToInt
implements LongToIntFunction {
    private static final Logger logger = LoggerFactory.getLogger(RandomLineToInt.class);
    private final List<String> lines;
    private final MersenneTwister rng;
    private final IntegerDistribution itemDistribution;
    private final String filename;

    public RandomLineToInt(String filename) {
        this(filename, System.nanoTime());
    }

    public RandomLineToInt(String filename, long seed) {
        this.filename = filename;
        this.lines = VirtDataResources.readDataFileLines(filename);
        this.rng = new MersenneTwister(seed);
        this.itemDistribution = new UniformIntegerDistribution(this.rng, 0, this.lines.size() - 2);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }

    @Override
    public int applyAsInt(long value) {
        int itemIdx = this.itemDistribution.sample();
        String item = this.lines.get(itemIdx);
        return Integer.valueOf(item);
    }
}

