/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.number.parse;

import com.ibm.icu.impl.number.parse.ParsedNumber;
import com.ibm.icu.impl.number.parse.ValidationMatcher;
import java.math.BigDecimal;
import java.math.MathContext;

public class MultiplierHandler
extends ValidationMatcher {
    private final BigDecimal multiplier;
    private final MathContext mc;
    private final boolean isNegative;

    public MultiplierHandler(BigDecimal multiplier, MathContext mc) {
        this.multiplier = BigDecimal.ONE.divide(multiplier, mc).abs();
        this.mc = mc;
        this.isNegative = multiplier.signum() < 0;
    }

    @Override
    public void postProcess(ParsedNumber result) {
        if (result.quantity != null) {
            result.quantity.multiplyBy(this.multiplier);
            result.quantity.roundToMagnitude(result.quantity.getMagnitude() - this.mc.getPrecision(), this.mc);
            if (this.isNegative) {
                result.flags ^= 1;
            }
        }
    }

    public String toString() {
        return "<MultiplierHandler " + this.multiplier + ">";
    }
}

