/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapper;
import io.virtdata.core.DataMapperFunctionMapper;
import io.virtdata.core.ResolvedFunction;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverDiagnostics {
    private static final Logger logger = LoggerFactory.getLogger(ResolverDiagnostics.class);
    private ResolvedFunction resolvedFunction;
    private final StringBuilder log = new StringBuilder();
    private Throwable error;

    public <T> Optional<DataMapper<T>> getOptionalMapper() {
        return Optional.ofNullable(this.resolvedFunction).map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
    }

    public Optional<ResolvedFunction> getResolvedFunction() {
        return Optional.ofNullable(this.getResolvedFunctionOrThrow());
    }

    public ResolvedFunction getResolvedFunctionOrThrow() {
        if (this.error != null) {
            throw new RuntimeException(this.error.getMessage(), this.error);
        }
        return this.resolvedFunction;
    }

    public ResolverDiagnostics error(Exception e) {
        this.error = e;
        this.log.append("ERROR encountered while resolving function:\n");
        this.log.append(e.toString()).append("\n");
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        String stacktrace = writer.toString();
        this.log.append("stack trace:\n");
        this.log.append(stacktrace);
        return this;
    }

    public ResolverDiagnostics setResolvedFunction(ResolvedFunction resolvedFunction) {
        this.resolvedFunction = resolvedFunction;
        return this;
    }

    public ResolverDiagnostics trace(String s) {
        logger.trace(s);
        this.log.append(s).append("\n");
        return this;
    }

    public String toString() {
        return this.log.toString();
    }
}

