/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.random;

import io.virtdata.annotations.DeprecatedFunction;
import io.virtdata.util.VirtDataResources;
import java.nio.CharBuffer;
import java.util.function.LongFunction;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomFileExtractToString
implements LongFunction<String> {
    private static final Logger logger = LoggerFactory.getLogger(RandomFileExtractToString.class);
    private static CharBuffer fileDataImage = null;
    private int minsize;
    private int maxsize;
    private final MersenneTwister rng;
    private final IntegerDistribution sizeDistribution;
    private final IntegerDistribution positionDistribution;
    private final String fileName;

    public RandomFileExtractToString(String fileName, int minsize, int maxsize) {
        this(fileName, minsize, maxsize, System.nanoTime());
    }

    public RandomFileExtractToString(String fileName, int minsize, int maxsize, long seed) {
        this.fileName = fileName;
        this.minsize = minsize;
        this.maxsize = maxsize;
        this.loadData();
        this.rng = new MersenneTwister(seed);
        this.sizeDistribution = new UniformIntegerDistribution(this.rng, minsize, maxsize);
        this.positionDistribution = new UniformIntegerDistribution(this.rng, 1, fileDataImage.limit() - maxsize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadData() {
        if (fileDataImage != null) return;
        Class<RandomFileExtractToString> clazz = RandomFileExtractToString.class;
        synchronized (RandomFileExtractToString.class) {
            CharBuffer image;
            if (fileDataImage != null) return;
            fileDataImage = image = VirtDataResources.readDataFileToCharBuffer(this.fileName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String apply(long input) {
        int offset = this.positionDistribution.sample();
        int length = this.sizeDistribution.sample();
        String sub = null;
        try {
            sub = fileDataImage.subSequence(offset, offset + length).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sub;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.minsize + ":" + this.maxsize;
    }
}

