/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.random;

import io.virtdata.annotations.DeprecatedFunction;
import io.virtdata.util.VirtDataResources;
import java.nio.CharBuffer;
import java.util.function.LongFunction;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomFileExtractToString
implements LongFunction<String> {
    private static final Logger logger = LoggerFactory.getLogger(RandomFileExtractToString.class);
    private static CharBuffer fileDataImage = null;
    private int minsize;
    private int maxsize;
    private final MersenneTwister rng;
    private final IntegerDistribution sizeDistribution;
    private final IntegerDistribution positionDistribution;
    private final String fileName;

    public RandomFileExtractToString(String string, int n, int n2) {
        this(string, n, n2, System.nanoTime());
    }

    public RandomFileExtractToString(String string, int n, int n2, long l) {
        this.fileName = string;
        this.minsize = n;
        this.maxsize = n2;
        this.loadData();
        this.rng = new MersenneTwister(l);
        this.sizeDistribution = new UniformIntegerDistribution(this.rng, n, n2);
        this.positionDistribution = new UniformIntegerDistribution(this.rng, 1, fileDataImage.limit() - n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadData() {
        if (fileDataImage != null) return;
        Class<RandomFileExtractToString> clazz = RandomFileExtractToString.class;
        synchronized (RandomFileExtractToString.class) {
            CharBuffer charBuffer;
            if (fileDataImage != null) return;
            fileDataImage = charBuffer = VirtDataResources.readDataFileToCharBuffer(this.fileName);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String apply(long l) {
        int n = this.positionDistribution.sample();
        int n2 = this.sizeDistribution.sample();
        String string = null;
        try {
            string = fileDataImage.subSequence(n, n + n2).toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return string;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.minsize + ":" + this.maxsize;
    }
}

