/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials.hash;

import java.math.BigInteger;
import org.greenrobot.essentials.PrimitiveArrayUtils;
import org.greenrobot.essentials.hash.Checksum128;

public class Murmur3F
implements Checksum128 {
    private static PrimitiveArrayUtils primitiveArrayUtils = PrimitiveArrayUtils.getInstance();
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;
    private final long seed;
    private long h1;
    private long h2;
    private int length;
    private int partialPos;
    private long partialK1;
    private long partialK2;
    private boolean finished;
    private long finishedH1;
    private long finishedH2;

    public Murmur3F() {
        this.seed = 0L;
    }

    public Murmur3F(int seed) {
        this.h1 = this.h2 = (this.seed = (long)seed & 0xFFFFFFFFL);
    }

    @Override
    public void update(int b) {
        this.finished = false;
        switch (this.partialPos) {
            case 0: {
                this.partialK1 = 0xFF & b;
                break;
            }
            case 1: {
                this.partialK1 |= (long)((0xFF & b) << 8);
                break;
            }
            case 2: {
                this.partialK1 |= (long)((0xFF & b) << 16);
                break;
            }
            case 3: {
                this.partialK1 |= (0xFFL & (long)b) << 24;
                break;
            }
            case 4: {
                this.partialK1 |= (0xFFL & (long)b) << 32;
                break;
            }
            case 5: {
                this.partialK1 |= (0xFFL & (long)b) << 40;
                break;
            }
            case 6: {
                this.partialK1 |= (0xFFL & (long)b) << 48;
                break;
            }
            case 7: {
                this.partialK1 |= (0xFFL & (long)b) << 56;
                break;
            }
            case 8: {
                this.partialK2 = 0xFF & b;
                break;
            }
            case 9: {
                this.partialK2 |= (long)((0xFF & b) << 8);
                break;
            }
            case 10: {
                this.partialK2 |= (long)((0xFF & b) << 16);
                break;
            }
            case 11: {
                this.partialK2 |= (0xFFL & (long)b) << 24;
                break;
            }
            case 12: {
                this.partialK2 |= (0xFFL & (long)b) << 32;
                break;
            }
            case 13: {
                this.partialK2 |= (0xFFL & (long)b) << 40;
                break;
            }
            case 14: {
                this.partialK2 |= (0xFFL & (long)b) << 48;
                break;
            }
            case 15: {
                this.partialK2 |= (0xFFL & (long)b) << 56;
            }
        }
        ++this.partialPos;
        if (this.partialPos == 16) {
            this.applyKs(this.partialK1, this.partialK2);
            this.partialPos = 0;
        }
        ++this.length;
    }

    public void updateLongLE(long value) {
        this.finished = false;
        switch (this.partialPos) {
            case 0: {
                this.partialK1 = value;
                break;
            }
            case 8: {
                this.partialK2 = value;
                break;
            }
            default: {
                throw new IllegalStateException("Cannot mix long with other alignments than 8: " + this.partialPos);
            }
        }
        this.partialPos += 8;
        if (this.partialPos == 16) {
            this.applyKs(this.partialK1, this.partialK2);
            this.partialPos = 0;
        }
        this.length += 8;
    }

    public void updateLongBE(long value) {
        this.updateLongLE(Long.reverseBytes(value));
    }

    @Override
    public void update(byte[] b) {
        this.update(b, 0, b.length);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        int i;
        this.finished = false;
        while (this.partialPos != 0 && len > 0) {
            this.update(b[off]);
            ++off;
            --len;
        }
        int remainder = len & 0xF;
        int stop = off + len - remainder;
        for (i = off; i < stop; i += 16) {
            long k1 = primitiveArrayUtils.getLongLE(b, i);
            long k2 = primitiveArrayUtils.getLongLE(b, i + 8);
            this.applyKs(k1, k2);
        }
        this.length += stop - off;
        for (i = 0; i < remainder; ++i) {
            this.update(b[stop + i]);
        }
    }

    private void applyKs(long k1, long k2) {
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        this.h1 ^= (k1 *= 5545529020109919103L);
        this.h1 = Long.rotateLeft(this.h1, 27);
        this.h1 += this.h2;
        this.h1 = this.h1 * 5L + 1390208809L;
        k2 *= 5545529020109919103L;
        k2 = Long.rotateLeft(k2, 33);
        this.h2 ^= (k2 *= -8663945395140668459L);
        this.h2 = Long.rotateLeft(this.h2, 31);
        this.h2 += this.h1;
        this.h2 = this.h2 * 5L + 944331445L;
    }

    private void checkFinished() {
        if (!this.finished) {
            this.finished = true;
            this.finishedH1 = this.h1;
            this.finishedH2 = this.h2;
            if (this.partialPos > 0) {
                if (this.partialPos > 8) {
                    long k2 = this.partialK2 * 5545529020109919103L;
                    k2 = Long.rotateLeft(k2, 33);
                    this.finishedH2 ^= (k2 *= -8663945395140668459L);
                }
                long k1 = this.partialK1 * -8663945395140668459L;
                k1 = Long.rotateLeft(k1, 31);
                this.finishedH1 ^= (k1 *= 5545529020109919103L);
            }
            this.finishedH1 ^= (long)this.length;
            this.finishedH2 ^= (long)this.length;
            this.finishedH1 += this.finishedH2;
            this.finishedH2 += this.finishedH1;
            this.finishedH1 = this.fmix64(this.finishedH1);
            this.finishedH2 = this.fmix64(this.finishedH2);
            this.finishedH1 += this.finishedH2;
            this.finishedH2 += this.finishedH1;
        }
    }

    private long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    @Override
    public long getValue() {
        this.checkFinished();
        return this.finishedH1;
    }

    @Override
    public long getValueHigh() {
        this.checkFinished();
        return this.finishedH2;
    }

    @Override
    public BigInteger getValueBigInteger() {
        byte[] bytes = this.getValueBytesBigEndian();
        return new BigInteger(1, bytes);
    }

    @Override
    public String getValueHexString() {
        this.checkFinished();
        return this.getPaddedHexString(this.finishedH2) + this.getPaddedHexString(this.finishedH1);
    }

    private String getPaddedHexString(long value) {
        String string = Long.toHexString(value);
        while (string.length() < 16) {
            string = '0' + string;
        }
        return string;
    }

    @Override
    public byte[] getValueBytesBigEndian() {
        int i;
        this.checkFinished();
        byte[] bytes = new byte[16];
        for (i = 0; i < 8; ++i) {
            bytes[i] = (byte)(this.finishedH2 >>> 56 - i * 8 & 0xFFL);
        }
        for (i = 0; i < 8; ++i) {
            bytes[8 + i] = (byte)(this.finishedH1 >>> 56 - i * 8 & 0xFFL);
        }
        return bytes;
    }

    @Override
    public byte[] getValueBytesLittleEndian() {
        int i;
        this.checkFinished();
        byte[] bytes = new byte[16];
        for (i = 0; i < 8; ++i) {
            bytes[i] = (byte)(this.finishedH1 >>> i * 8 & 0xFFL);
        }
        for (i = 0; i < 8; ++i) {
            bytes[8 + i] = (byte)(this.finishedH2 >>> i * 8 & 0xFFL);
        }
        return bytes;
    }

    @Override
    public void reset() {
        this.h1 = this.h2 = this.seed;
        this.length = 0;
        this.partialPos = 0;
        this.finished = false;
        this.partialK2 = 0L;
        this.partialK1 = 0L;
        this.finishedH2 = 0L;
        this.finishedH1 = 0L;
    }
}

