/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.random;

import io.virtdata.annotations.DeprecatedFunction;
import io.virtdata.util.VirtDataResources;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomLineToString
implements LongFunction<String> {
    private static final Logger logger = LoggerFactory.getLogger(RandomLineToString.class);
    private List<String> lines = new ArrayList<String>();
    private final MersenneTwister rng;
    private final IntegerDistribution itemDistribution;
    private final String filename;

    public RandomLineToString(String string) {
        this.rng = new MersenneTwister(System.nanoTime());
        this.filename = string;
        this.lines = VirtDataResources.readDataFileLines(string);
        this.itemDistribution = new UniformIntegerDistribution(this.rng, 0, this.lines.size() - 2);
    }

    public RandomLineToString(String string, MersenneTwister mersenneTwister) {
        this.rng = mersenneTwister;
        this.filename = string;
        this.lines = VirtDataResources.readDataFileLines(string);
        this.lines = VirtDataResources.readDataFileLines(string);
        this.itemDistribution = new UniformIntegerDistribution(mersenneTwister, 0, this.lines.size() - 2);
    }

    public RandomLineToString(String string, long l) {
        this.rng = new MersenneTwister(l);
        this.filename = string;
        this.lines = VirtDataResources.readDataFileLines(string);
        this.itemDistribution = new UniformIntegerDistribution(this.rng, 0, this.lines.size() - 2);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }

    @Override
    public String apply(long l) {
        int n = this.itemDistribution.sample();
        String string = this.lines.get(n);
        return string;
    }
}

