/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api;

import io.virtdata.api.DataMapper;
import io.virtdata.api.Named;
import io.virtdata.api.ValueType;
import io.virtdata.ast.Expression;
import io.virtdata.ast.FunctionCall;
import io.virtdata.core.DataMapperFunctionMapper;
import io.virtdata.core.ResolvedFunction;
import io.virtdata.parser.VirtDataDSL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public interface VirtDataFunctionLibrary
extends Named {
    public List<ResolvedFunction> resolveFunctions(Class<?> var1, Class<?> var2, String var3, Map<String, ?> var4, Object ... var5);

    default public List<ResolvedFunction> resolveFunction(String string) {
        return this.resolveFunctions(string, new HashMap<String, Object>());
    }

    default public List<ResolvedFunction> resolveFunctions(String string, Map<String, Object> map) {
        ArrayList<ResolvedFunction> arrayList = new ArrayList<ResolvedFunction>();
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse(string);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        List<Expression> list = parseResult.flow.getExpressions();
        if (list.size() > 1) {
            throw new RuntimeException("Unable to promote a lambda flow to a data mapper here.");
        }
        FunctionCall functionCall = list.get(0).getCall();
        List<ResolvedFunction> list2 = this.resolveFunctions(Optional.ofNullable(functionCall.getOutputType()).map(ValueType::valueOfClassName).map(ValueType::getValueClass).orElse(null), Optional.ofNullable(functionCall.getInputType()).map(ValueType::valueOfClassName).map(ValueType::getValueClass).orElse(null), functionCall.getFunctionName(), map, functionCall.getArguments());
        arrayList.addAll(list2);
        return arrayList;
    }

    default public <T> List<DataMapper<T>> getDataMappers(String string) {
        return this.getDataMappers(string, new HashMap<String, Object>());
    }

    default public <T> List<DataMapper<T>> getDataMappers(String string, Map<String, Object> map) {
        List<ResolvedFunction> list = this.resolveFunctions(string, map);
        return list.stream().map(resolvedFunction -> DataMapperFunctionMapper.map(resolvedFunction.getFunctionObject())).collect(Collectors.toList());
    }

    default public <T> Optional<DataMapper<T>> getDataMapper(String string) {
        return this.getDataMapper(string, new HashMap<String, Object>());
    }

    default public <T> Optional<DataMapper<T>> getDataMapper(String string, Map<String, Object> map) {
        List<ResolvedFunction> list = this.resolveFunctions(string, map);
        switch (list.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(DataMapperFunctionMapper.map(list.get(0).getFunctionObject()));
            }
        }
        throw new RuntimeException("Found " + list.size() + " data mapping functions, expected exactly one for library-level function lookups. This may require both an input and an output type qualifier like 'int -> f() -> int'. \nFound: [<library name>::] input->class->output [initializer type->parameter type,...]: \n" + list.stream().map(String::valueOf).collect(Collectors.joining("\n")));
    }
}

