/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.FunctionType;
import io.virtdata.api.ValueType;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;

public class ResolvedFunction {
    public static Comparator<ResolvedFunction> PREFERRED_TYPE_COMPARATOR = new PreferredTypeComparator();
    private final Class<?> inputType;
    private final Class<?> outputType;
    private Class<?>[] initializerSignature;
    private Object[] initializerValues;
    private FunctionType functionType;
    private Object functionObject;
    private String libraryName;
    private boolean isThreadSafe;
    private static MethodHandles.Lookup methodLookup = MethodHandles.publicLookup();

    public ResolvedFunction(Object object, boolean bl, Class<?>[] classArray, Object[] objectArray, Class<?> clazz, Class<?> clazz2, String string) {
        this(object, bl, classArray, objectArray, clazz, clazz2);
        this.libraryName = string;
    }

    public ResolvedFunction(Object object, boolean bl, Class<?>[] classArray, Object[] objectArray, Class<?> clazz, Class<?> clazz2) {
        this.functionObject = object;
        this.isThreadSafe = bl;
        this.functionType = FunctionType.valueOf(object);
        this.initializerSignature = classArray;
        this.initializerValues = objectArray;
        this.inputType = clazz;
        this.outputType = clazz2;
    }

    public static String getStringLegend() {
        return "[<library name>::] input->class->output [initializer type->parameter type,...]";
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public void setFunctionType(FunctionType functionType) {
        this.functionType = functionType;
    }

    public Object getFunctionObject() {
        return this.functionObject;
    }

    public void setFunctionObject(Object object) {
        this.functionObject = object;
    }

    public Class<?> getResultClass() {
        Method method = this.getMethod();
        return method.getReturnType();
    }

    public Class<?> getInputClass() {
        Method method = this.getMethod();
        return method.getParameterTypes()[0];
    }

    public Class<?> getArgType() {
        Method method = this.getMethod();
        if (method.getParameterCount() != 1) {
            throw new RuntimeException("The parameter found is supposed to be 1, but it was" + method.getParameterCount());
        }
        return method.getParameterTypes()[0];
    }

    private Method getMethod() {
        Optional<Method> optional = Arrays.stream(this.functionObject.getClass().getMethods()).filter(method -> !method.isSynthetic() && !method.isBridge() && !method.isDefault()).filter(method -> method.getName().startsWith("apply")).findFirst();
        return optional.orElseThrow(() -> new RuntimeException("Unable to find the function method on " + this.functionObject.getClass().getCanonicalName()));
    }

    public boolean isThreadSafe() {
        return this.isThreadSafe;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.libraryName != null) {
            stringBuilder.append(this.libraryName).append("::");
        }
        stringBuilder.append(this.getArgType().getSimpleName()).append("->");
        stringBuilder.append(this.getMethod().getDeclaringClass().getName());
        stringBuilder.append("->").append(this.getResultClass().getName());
        if (this.initializerValues != null && this.initializerValues.length > 0) {
            stringBuilder.append(" [");
            for (int i = 0; i < this.initializerSignature.length; ++i) {
                Class<?> clazz = this.initializerSignature[i];
                Object object = clazz.isPrimitive() ? clazz.getName() : clazz.getSimpleName();
                Object object2 = "[]";
                if (i < this.initializerValues.length) {
                    Class<?> clazz2 = this.initializerValues[i].getClass();
                    Object object3 = object2 = clazz2.isPrimitive() ? clazz2.getName() : clazz2.getSimpleName();
                }
                if (this.initializerSignature.length != this.initializerValues.length && i == this.initializerSignature.length - 1) {
                    object = ((String)object).replaceAll("\\[]", "") + "...";
                    object2 = ((String)object2).replaceAll("\\[]", "") + "...";
                }
                stringBuilder.append((String)object2).append("=>").append((String)object);
                stringBuilder.append(",");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    private static class PreferredTypeComparator
    implements Comparator<ResolvedFunction> {
        private PreferredTypeComparator() {
        }

        @Override
        public int compare(ResolvedFunction resolvedFunction, ResolvedFunction resolvedFunction2) {
            ValueType valueType;
            ValueType valueType2 = ValueType.valueOfAssignableClass(resolvedFunction.getArgType());
            int n = valueType2.compareTo(valueType = ValueType.valueOfAssignableClass(resolvedFunction2.getArgType()));
            if (n != 0) {
                return n;
            }
            valueType2 = ValueType.valueOfAssignableClass(resolvedFunction.getResultClass());
            valueType = ValueType.valueOfAssignableClass(resolvedFunction2.getResultClass());
            return valueType2.compareTo(valueType);
        }
    }
}

