/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.random;

import io.virtdata.annotations.DeprecatedFunction;
import io.virtdata.api.DataMapper;
import org.apache.commons.math3.random.MersenneTwister;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomRangedToDouble
implements DataMapper<Double> {
    private final MersenneTwister theTwister;
    private final long min;
    private final long max;
    private final long length;

    public RandomRangedToDouble(long l, long l2) {
        this(l, l2, System.nanoTime());
    }

    public RandomRangedToDouble(long l, long l2, long l3) {
        this.theTwister = new MersenneTwister(l3);
        if (l2 <= l) {
            throw new RuntimeException("max must be >= min");
        }
        this.min = l;
        this.max = l2;
        this.length = l2 - l;
    }

    @Override
    public Double get(long l) {
        Double d = Math.abs(this.theTwister.nextDouble());
        d = d % (double)this.length;
        d = d + (double)this.min;
        return d;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.min + ":" + this.max;
    }
}

