/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api.composers;

import io.virtdata.api.FunctionType;
import io.virtdata.api.composers.ComposerForDoubleFunction;
import io.virtdata.api.composers.ComposerForDoubleToIntFunction;
import io.virtdata.api.composers.ComposerForDoubleToLongFunction;
import io.virtdata.api.composers.ComposerForDoubleUnaryOperator;
import io.virtdata.api.composers.ComposerForFunction;
import io.virtdata.api.composers.ComposerForIntFunction;
import io.virtdata.api.composers.ComposerForIntToDoubleFunction;
import io.virtdata.api.composers.ComposerForIntToLongFunction;
import io.virtdata.api.composers.ComposerForIntUnaryOperator;
import io.virtdata.api.composers.ComposerForLongFunction;
import io.virtdata.api.composers.ComposerForLongToDoubleFunction;
import io.virtdata.api.composers.ComposerForLongToIntFunction;
import io.virtdata.api.composers.ComposerForLongUnaryOperator;
import io.virtdata.api.composers.FunctionComposer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionAssembly
implements FunctionComposer {
    private static final Logger logger = LoggerFactory.getLogger(FunctionAssembly.class);
    private FunctionComposer<?> composer = null;

    @Override
    public Object getFunctionObject() {
        if (this.composer != null) {
            return this.composer.getFunctionObject();
        }
        throw new RuntimeException("No function have been passed for assembly.");
    }

    @Override
    public FunctionComposer andThen(Object object) {
        try {
            this.composer = this.composer != null ? this.composer.andThen(object) : this.andThenInitial(object);
            return this.composer;
        }
        catch (Exception exception) {
            logger.error("Error while composing functions:\n");
            if (this.composer != null) {
                logger.error("composer: class:" + this.composer.getClass().getSimpleName() + ", toString:" + this.composer.toString());
            }
            logger.error("outer: class:" + object.getClass() + ", toString:" + object.toString());
            throw exception;
        }
    }

    private FunctionComposer<?> andThenInitial(Object object) {
        try {
            FunctionType functionType = FunctionType.valueOf(object);
            switch (functionType) {
                case long_long: {
                    return new ComposerForLongUnaryOperator((LongUnaryOperator)object);
                }
                case long_int: {
                    return new ComposerForLongToIntFunction((LongToIntFunction)object);
                }
                case long_double: {
                    return new ComposerForLongToDoubleFunction((LongToDoubleFunction)object);
                }
                case long_T: {
                    return new ComposerForLongFunction((LongFunction)object);
                }
                case int_int: {
                    return new ComposerForIntUnaryOperator((IntUnaryOperator)object);
                }
                case int_long: {
                    return new ComposerForIntToLongFunction((IntToLongFunction)object);
                }
                case int_double: {
                    return new ComposerForIntToDoubleFunction((IntToDoubleFunction)object);
                }
                case int_T: {
                    return new ComposerForIntFunction((IntFunction)object);
                }
                case double_double: {
                    return new ComposerForDoubleUnaryOperator((DoubleUnaryOperator)object);
                }
                case double_long: {
                    return new ComposerForDoubleToLongFunction((DoubleToLongFunction)object);
                }
                case double_int: {
                    return new ComposerForDoubleToIntFunction((DoubleToIntFunction)object);
                }
                case double_T: {
                    return new ComposerForDoubleFunction((DoubleFunction)object);
                }
                case R_T: {
                    return new ComposerForFunction((Function)object);
                }
            }
            throw new RuntimeException("Unrecognized function type:" + functionType);
        }
        catch (Exception exception) {
            logger.error("Error while setting up initial composer state for function class:" + object.getClass().getSimpleName() + ", toString:" + object.toString());
            throw exception;
        }
    }

    public String toString() {
        return "composer:" + this.composer;
    }
}

