/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;

public class FunctionTyper {
    public static Class<?> getResultClass(Class<?> clazz) {
        FunctionTyper.assertFunctionalInterface(clazz);
        Method method = FunctionTyper.getMethod(clazz);
        return method.getReturnType();
    }

    public static Class<?> getInputClass(Class<?> clazz) {
        FunctionTyper.assertFunctionalInterface(clazz);
        Method method = FunctionTyper.getMethod(clazz);
        return method.getParameterTypes()[0];
    }

    public static Class<?> getArgType(Method method) {
        if (method.getParameterCount() != 1) {
            throw new RuntimeException("The parameter found is supposed to be 1, but it was" + method.getParameterCount());
        }
        return method.getParameterTypes()[0];
    }

    private static Method getMethod(Class<?> clazz) {
        FunctionTyper.assertFunctionalInterface(clazz);
        Optional<Method> optional = Arrays.stream(clazz.getMethods()).filter(method -> !method.isSynthetic() && !method.isBridge() && !method.isDefault()).filter(method -> method.getName().startsWith("apply")).findFirst();
        return optional.orElseThrow(() -> new RuntimeException("Unable to find the function method on " + clazz.getCanonicalName()));
    }

    private static void assertFunctionalInterface(Class<?> clazz) {
        if (clazz.getAnnotation(FunctionalInterface.class) == null) {
            throw new RuntimeException("type " + clazz.getCanonicalName() + " is not a functional type");
        }
        if (!clazz.isInterface()) {
            throw new RuntimeException("type " + clazz.getCanonicalName() + " is not an interface.");
        }
    }
}

