/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.core.Bindings;
import io.virtdata.core.VirtData;
import io.virtdata.core.VirtDataDocs;
import io.virtdata.templates.BindPoint;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingsTemplate {
    private static final Logger logger = LoggerFactory.getLogger(BindingsTemplate.class);
    private List<String> bindPointNames = new ArrayList<String>();
    private List<String> specifiers = new ArrayList<String>();

    public BindingsTemplate(List<String> list, List<String> list2) {
        if (list.size() != list2.size()) {
            throw new InvalidParameterException("Anchors and Specifiers must be matched pair-wise.");
        }
        for (int i = 0; i < list.size(); ++i) {
            this.addFieldBinding(list.get(i), list2.get(i));
        }
    }

    public BindingsTemplate(List<BindPoint> list) {
        this.addFieldBindings(list);
    }

    public BindingsTemplate() {
    }

    public void addFieldBindings(List<BindPoint> list) {
        for (BindPoint bindPoint : list) {
            this.addFieldBinding(bindPoint.getAnchor(), bindPoint.getBindspec());
        }
    }

    public void addFieldBinding(String string, String string2) {
        this.bindPointNames.add(string);
        this.specifiers.add(string2);
    }

    public void addFieldBindings(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.bindPointNames.add(entry.getKey());
            this.specifiers.add(entry.getValue());
        }
    }

    public Bindings resolveBindings() {
        ArrayList arrayList = new ArrayList();
        for (String string : this.specifiers) {
            Optional optional = VirtData.getOptionalMapper(string);
            if (optional.isPresent()) {
                arrayList.add(optional.get());
                continue;
            }
            this.logAvailableDataMappers();
            throw new RuntimeException("data mapper binding was unsuccessful for , spec:" + string + ", see log for known data mapper names.");
        }
        return new Bindings(this, arrayList);
    }

    private void logAvailableDataMappers() {
        VirtDataDocs.getAllNames().forEach(string -> logger.info("DATAMAPPER " + string));
    }

    public List<String> getBindPointNames() {
        return this.bindPointNames;
    }

    public List<String> getDataMapperSpecs() {
        return this.specifiers;
    }

    public String toString() {
        String string = "";
        StringBuilder stringBuilder = new StringBuilder(BindingsTemplate.class.getSimpleName()).append(":");
        for (int i = 0; i < this.bindPointNames.size(); ++i) {
            stringBuilder.append(string);
            stringBuilder.append("'").append(this.bindPointNames.get(i)).append("'");
            stringBuilder.append("=>");
            stringBuilder.append("\"").append(this.specifiers.get(i)).append("\"");
            string = ", ";
        }
        return stringBuilder.toString();
    }

    public String toString(Object[] objectArray) {
        String string = "";
        StringBuilder stringBuilder = new StringBuilder(BindingsTemplate.class.getSimpleName()).append(":");
        for (int i = 0; i < this.bindPointNames.size(); ++i) {
            stringBuilder.append(string);
            stringBuilder.append("'").append(this.bindPointNames.get(i)).append("'");
            stringBuilder.append("=>");
            stringBuilder.append("\"").append(this.specifiers.get(i)).append("\"");
            stringBuilder.append("=>[");
            stringBuilder.append(objectArray[i]);
            stringBuilder.append("](");
            stringBuilder.append(null != objectArray[i] ? objectArray[i].getClass().getSimpleName() : "NULL");
            stringBuilder.append(")");
            string = ", ";
        }
        return stringBuilder.toString();
    }
}

