/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.core;

import io.virtdata.api.DataMapper;
import io.virtdata.api.ValueType;
import io.virtdata.ast.VirtDataFlow;
import io.virtdata.core.BindingsTemplate;
import io.virtdata.core.CompatibilityFixups;
import io.virtdata.core.DataMapperFunctionMapper;
import io.virtdata.core.FunctionTyper;
import io.virtdata.core.ResolvedFunction;
import io.virtdata.core.ResolverDiagnostics;
import io.virtdata.core.VirtDataComposer;
import io.virtdata.parser.VirtDataDSL;
import io.virtdata.templates.BindPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtData {
    private static final Logger logger = LoggerFactory.getLogger(VirtData.class);

    public static BindingsTemplate getTemplate(String ... stringArray) {
        if (stringArray.length % 2 != 0) {
            throw new RuntimeException("args must be in 'name','spec', pairs. This can't be true for " + stringArray.length + "elements.");
        }
        ArrayList<BindPoint> arrayList = new ArrayList<BindPoint>();
        for (int i = 0; i < stringArray.length; i += 2) {
            arrayList.add(new BindPoint(stringArray[i], stringArray[i + 1]));
        }
        return VirtData.getTemplate(arrayList);
    }

    public static BindingsTemplate getTemplate(List<BindPoint> list) {
        for (BindPoint bindPoint : list) {
            String string = bindPoint.getBindspec();
            VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse(string);
            if (parseResult.throwable == null) continue;
            throw new RuntimeException(parseResult.throwable);
        }
        return new BindingsTemplate(list);
    }

    public static <T> Optional<DataMapper<T>> getOptionalMapper(String string, Map<String, ?> map) {
        string = CompatibilityFixups.fixup(string);
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse(string);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow virtDataFlow = parseResult.flow;
        VirtDataComposer virtDataComposer = new VirtDataComposer();
        virtDataComposer.addCustomElements(map);
        Optional<ResolvedFunction> optional = virtDataComposer.resolveFunctionFlow(virtDataFlow);
        return optional.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
    }

    public static <T> Optional<DataMapper<T>> getOptionalMapper(String string) {
        return VirtData.getOptionalMapper(string, Collections.emptyMap());
    }

    public static ResolverDiagnostics getMapperDiagnostics(String string) {
        return VirtData.getMapperDiagnostics(string, Collections.emptyMap());
    }

    public static ResolverDiagnostics getMapperDiagnostics(String string, Map<String, Object> map) {
        try {
            string = CompatibilityFixups.fixup(string);
            VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse(string);
            if (parseResult.throwable != null) {
                throw new RuntimeException(parseResult.throwable);
            }
            VirtDataFlow virtDataFlow = parseResult.flow;
            VirtDataComposer virtDataComposer = new VirtDataComposer();
            virtDataComposer.addCustomElements(map);
            ResolverDiagnostics resolverDiagnostics = virtDataComposer.resolveDiagnosticFunctionFlow(virtDataFlow);
            return resolverDiagnostics;
        }
        catch (Exception exception) {
            return new ResolverDiagnostics().error(exception);
        }
    }

    public static <T> Optional<DataMapper<T>> getOptionalMapper(String string, Class<? extends T> clazz) {
        return VirtData.getOptionalMapper(string, clazz, Collections.emptyMap());
    }

    public static <T> Optional<DataMapper<T>> getOptionalMapper(String string, Class<?> clazz, Map<String, Object> map) {
        Object r;
        string = CompatibilityFixups.fixup(string);
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse(string);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow virtDataFlow = parseResult.flow;
        String string2 = virtDataFlow.getLastExpression().getCall().getOutputType();
        Class<?> clazz2 = ValueType.classOfType(string2);
        if (clazz2 != null) {
            if (!ClassUtils.isAssignable(clazz2, clazz, true)) {
                throw new RuntimeException("The flow specifier '" + string + "' wants an output type of '" + string2 + "', but this type is not assignable to the explicit class '" + clazz.getCanonicalName() + "' that was enforced at the API level. Either remove the output type qualifier at the last function in the flow spec, or change it to something that can reliably be cast to type '" + clazz.getCanonicalName() + "'");
            }
        } else {
            logger.debug("Auto-assigning output type qualifier '->" + clazz.getCanonicalName() + "' to specifier '" + string + "'");
            virtDataFlow.getLastExpression().getCall().setOutputType(clazz.getCanonicalName());
        }
        VirtDataComposer virtDataComposer = new VirtDataComposer();
        virtDataComposer.addCustomElements(map);
        Optional<ResolvedFunction> optional = virtDataComposer.resolveFunctionFlow(virtDataFlow);
        Optional<DataMapper<T>> optional2 = optional.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        if (optional2.isPresent() && !ClassUtils.isAssignable((r = optional2.get().get(1L)).getClass(), clazz, true)) {
            throw new RuntimeException("The flow specifier '" + string + "' successfully created a function, but the test value(" + String.valueOf(r) + ") of type [" + r.getClass() + "] produced by it was not assignable to the type '" + clazz.getCanonicalName() + "' which was explicitly set at the API level.");
        }
        return optional2;
    }

    public static <T> T getFunction(String string, Class<? extends T> clazz) {
        return VirtData.getFunction(string, clazz, Collections.emptyMap());
    }

    public static <T> T getFunction(String string, Class<? extends T> clazz, Map<String, Object> map) {
        Optional<T> optional = VirtData.getOptionalFunction(string, clazz, map);
        return optional.orElseThrow();
    }

    public static <T> Optional<T> getOptionalFunction(String string, Class<? extends T> clazz) {
        return VirtData.getOptionalFunction(string, clazz, Collections.emptyMap());
    }

    public static <T> Optional<T> getOptionalFunction(String string, Class<? extends T> clazz, Map<String, Object> map) {
        String string2;
        Class<?> clazz2;
        string = CompatibilityFixups.fixup(string);
        Class<?> clazz3 = FunctionTyper.getInputClass(clazz);
        Class<?> clazz4 = FunctionTyper.getResultClass(clazz);
        FunctionalInterface functionalInterface = clazz.getAnnotation(FunctionalInterface.class);
        if (functionalInterface == null) {
            throw new RuntimeException("You can only use function types that are tagged as @FunctionInterface");
        }
        VirtDataDSL.ParseResult parseResult = VirtDataDSL.parse(string);
        if (parseResult.throwable != null) {
            throw new RuntimeException(parseResult.throwable);
        }
        VirtDataFlow virtDataFlow = parseResult.flow;
        String string3 = virtDataFlow.getFirstExpression().getCall().getInputType();
        Class<?> clazz5 = ValueType.classOfType(string3);
        if (clazz5 != null) {
            if (!ClassUtils.isAssignable(clazz5, clazz3, true)) {
                throw new RuntimeException("The flow specifier '" + string + "' wants an input type of '" + string3 + "', but this type is not assignable to the input class required by the functional type requested '" + clazz.getCanonicalName() + "'. (type " + clazz3.getCanonicalName() + ") Either remove the input type qualifier at the first function in the flow spec, or change it to something that can reliably be cast to type '" + clazz3.getCanonicalName() + "'");
            }
        } else {
            logger.debug("Auto-assigning input type qualifier '" + clazz3.getCanonicalName() + "->' to specifier '" + string + "'");
            virtDataFlow.getFirstExpression().getCall().setInputType(clazz3.getCanonicalName());
        }
        if ((clazz2 = ValueType.classOfType(string2 = virtDataFlow.getLastExpression().getCall().getOutputType())) != null) {
            if (!ClassUtils.isAssignable(clazz2, clazz4, true)) {
                throw new RuntimeException("The flow specifier '" + string + "' wants an output type of '" + clazz2 + "', but this type is not assignable to the output class required by functional type '" + clazz.getCanonicalName() + "'. (type " + clazz4.getCanonicalName() + ") Either remove the output type qualifier at the last function in the flow spec, or change it to something that can reliably be cast to type '" + clazz4.getCanonicalName() + "'");
            }
        } else {
            logger.debug("Auto-assigning output type qualifier '->" + clazz4.getCanonicalName() + "' to specifier '" + string + "'");
            virtDataFlow.getLastExpression().getCall().setOutputType(clazz4.getCanonicalName());
        }
        VirtDataComposer virtDataComposer = new VirtDataComposer();
        virtDataComposer.addCustomElements(map);
        Optional<ResolvedFunction> optional = virtDataComposer.resolveFunctionFlow(virtDataFlow);
        return optional.map(ResolvedFunction::getFunctionObject).map(clazz::cast);
    }

    public static <T> DataMapper<T> getMapper(String string, Map<String, Object> map) {
        Optional<DataMapper<T>> optional = VirtData.getOptionalMapper(string, map);
        return optional.orElseThrow(() -> new RuntimeException("Unable to find mapper: " + string));
    }

    public static <T> DataMapper<T> getMapper(String string) {
        return VirtData.getMapper(string, Collections.emptyMap());
    }

    public static <T> DataMapper<T> getMapper(String string, Class<? extends T> clazz, Map<String, Object> map) {
        Optional<DataMapper<T>> optional = VirtData.getOptionalMapper(string, clazz);
        DataMapper<? extends T> dataMapper = optional.orElseThrow(() -> new RuntimeException("Unable to find mapper: " + string));
        return dataMapper;
    }

    public static <T> DataMapper<T> getMapper(String string, Class<? extends T> clazz) {
        return VirtData.getMapper(string, clazz, Collections.emptyMap());
    }
}

