/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.processors;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeSpec;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFunc;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import io.virtdata.processors.FuncEnumerator;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;

public class FunctionDocInfoWriter
implements FuncEnumerator.Listener {
    private final String suffix;
    private Filer filer;
    private Messager messenger;

    public FunctionDocInfoWriter(Filer filer, Messager messager, String string) {
        this.filer = filer;
        this.messenger = messager;
        this.suffix = string;
    }

    @Override
    public void onFunctionModel(DocForFunc docForFunc) {
        TypeSpec typeSpec = this.createInlineClassForDocFuncData(docForFunc, docForFunc.getClassName() + this.suffix);
        JavaFile javaFile = JavaFile.builder(docForFunc.getPackageName(), typeSpec).addFileComment("This file is auto-generated.", new Object[0]).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException iOException) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, "Error writing javafile " + javaFile.packageName + "." + javaFile.typeSpec.toString());
            throw new RuntimeException(iOException);
        }
    }

    private TypeSpec createInlineClassForDocFuncData(DocForFunc docForFunc, String string) {
        Object object222;
        ArrayList<MethodSpec> arrayList = new ArrayList<MethodSpec>();
        MethodSpec methodSpec = MethodSpec.methodBuilder("getClassName").addModifiers(Modifier.PUBLIC).returns((Type)((Object)String.class)).addStatement("return $S", docForFunc.getClassName()).build();
        arrayList.add(methodSpec);
        MethodSpec methodSpec2 = MethodSpec.methodBuilder("getPackageName").addModifiers(Modifier.PUBLIC).returns((Type)((Object)String.class)).addStatement("return $S", docForFunc.getPackageName()).build();
        arrayList.add(methodSpec2);
        MethodSpec methodSpec3 = MethodSpec.methodBuilder("getClassJavadoc").addModifiers(Modifier.PUBLIC).returns((Type)((Object)String.class)).addStatement("return $S", docForFunc.getClassJavadoc()).build();
        arrayList.add(methodSpec3);
        MethodSpec methodSpec4 = MethodSpec.methodBuilder("getInType").addModifiers(Modifier.PUBLIC).returns((Type)((Object)String.class)).addStatement("return $S", docForFunc.getInType()).build();
        arrayList.add(methodSpec4);
        MethodSpec methodSpec5 = MethodSpec.methodBuilder("getOutType").addModifiers(Modifier.PUBLIC).returns((Type)((Object)String.class)).addStatement("return $S", docForFunc.getOutType()).build();
        arrayList.add(methodSpec5);
        CodeBlock codeBlock = CodeBlock.builder().add("return new $T<$T>() {{$>\n", ArrayList.class, DocCtorData.class).build();
        CodeBlock codeBlock2 = CodeBlock.builder().add("$<}}", new Object[0]).build();
        CodeBlock.Builder builder = CodeBlock.builder().add(codeBlock);
        for (Object object222 : docForFunc.getCtors()) {
            builder.add("add(new $T($S, $S, \n$>new $T<String, String>() {{\n$>", DocForFuncCtor.class, object222.getClassName(), object222.getCtorJavaDoc(), LinkedHashMap.class);
            for (Map.Entry<String, String> entry : object222.getArgs().entrySet()) {
                builder.add("put($S,$S);\n", entry.getKey(), entry.getValue());
            }
            builder.add("$<}},\n", new Object[0]);
            builder.add("new $T<$T<$T>>() {{\n$>", ArrayList.class, List.class, String.class);
            for (List list : object222.getExamples()) {
                builder.add("add(new $T<$T>() {{$>\n", ArrayList.class, String.class);
                for (String string2 : list) {
                    Matcher matcher = Pattern.compile(Matcher.quoteReplacement("$")).matcher(string2);
                    string2 = matcher.replaceAll(Matcher.quoteReplacement("$$"));
                    builder.add("add(\"" + string2 + "\");\n", new Object[0]);
                }
                builder.add("$<}});\n", new Object[0]);
            }
            builder.add("$<}}", new Object[0]);
            builder.add("\n$<));\n", new Object[0]);
        }
        builder.add(codeBlock2);
        MethodSpec methodSpec6 = MethodSpec.methodBuilder("getCategories").addModifiers(Modifier.PUBLIC).returns(ArrayTypeName.of(Category.class)).addStatement("return new $T[] { " + Arrays.stream(docForFunc.getCategories()).map(category -> "Category." + category).collect(Collectors.joining(",")) + " }", Category.class).build();
        arrayList.add(methodSpec6);
        object222 = MethodSpec.methodBuilder("getCtors").addModifiers(Modifier.PUBLIC).returns(ParameterizedTypeName.get(List.class, new Type[]{DocCtorData.class})).addStatement(builder.build()).build();
        arrayList.add((MethodSpec)object222);
        AnnotationSpec annotationSpec = AnnotationSpec.builder(Service.class).addMember("value", "$T.class", DocFuncData.class).build();
        TypeSpec typeSpec = TypeSpec.classBuilder(string).addAnnotation(annotationSpec).addModifiers(Modifier.PUBLIC).addMethods(arrayList).addSuperinterface((Type)((Object)DocFuncData.class)).build();
        return typeSpec;
    }
}

