/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.file.AccessMode;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtDataResources {
    public static final String DATA_DIR = "data";
    private static final Logger logger = LoggerFactory.getLogger(VirtDataResources.class);

    public static CharBuffer readDataFileToCharBuffer(String string) {
        return VirtDataResources.loadFileToCharBuffer(string, DATA_DIR);
    }

    public static List<String> readDataFileLines(String string) {
        return VirtDataResources.readFileLines(string, DATA_DIR);
    }

    public static String readDataFileString(String string) {
        return VirtDataResources.readFileString(string, DATA_DIR);
    }

    public static InputStream findRequiredStreamOrFile(String string, String string2, String ... stringArray) {
        Optional<InputStream> optional = VirtDataResources.findOptionalStreamOrFile(string, string2, stringArray);
        return optional.orElseThrow(() -> new RuntimeException("Unable to find " + string + " with extension " + string2 + " in file system or in classpath, with search paths: " + Arrays.stream(stringArray).collect(Collectors.joining(","))));
    }

    public static Reader findRequiredReader(String string, String string2, String ... stringArray) {
        Optional<Reader> optional = VirtDataResources.findOptionalReader(string, string2, stringArray);
        return optional.orElseThrow(() -> new RuntimeException("Unable to find " + string + " with extension " + string2 + " in file system or in classpath, with search paths: " + Arrays.stream(stringArray).collect(Collectors.joining(","))));
    }

    public static Optional<Reader> findOptionalReader(String string, String string2, String ... stringArray) {
        return VirtDataResources.findOptionalStreamOrFile(string, string2, stringArray).map(InputStreamReader::new).map(BufferedReader::new);
    }

    public static Optional<Path> findOptionalDirPath(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            try {
                return Optional.of(Path.of(uRL.toURI()));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        }
        return Optional.empty();
    }

    public static Optional<InputStream> findOptionalStreamOrFile(final String string, String string2, final String ... stringArray) {
        boolean bl = string2 != null && !string2.isEmpty() && !string.endsWith("." + string2);
        final String string3 = string + (String)(bl ? "." + string2 : "");
        ArrayList<String> arrayList = new ArrayList<String>(){
            {
                this.add(string3);
                if (!VirtDataResources.isRemote(string)) {
                    this.addAll(Arrays.stream(stringArray).map(string2 -> string2 + File.separator + string3).collect(Collectors.toCollection(ArrayList::new)));
                }
            }
        };
        for (String string4 : arrayList) {
            Optional<InputStream> optional = VirtDataResources.getInputStream(string4);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    private static boolean isRemote(String string) {
        return string.toLowerCase().startsWith("http:") || string.toLowerCase().startsWith("https:");
    }

    public static Optional<InputStream> getInputStream(String string) {
        Object object;
        if (VirtDataResources.isRemote(string) && (object = VirtDataResources.getInputStreamForUrl(string)) != null) {
            return object;
        }
        try {
            object = new FileInputStream(string);
            return Optional.of(object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ClassLoader classLoader = VirtDataResources.class.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(string);
            if (inputStream != null) {
                return Optional.of(inputStream);
            }
            return Optional.empty();
        }
    }

    public static Optional<InputStream> getInputStreamForUrl(String string) {
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            if (inputStream != null) {
                return Optional.of(inputStream);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return null;
    }

    public static List<String> readFileLines(String string, String ... stringArray) {
        List<String> list;
        InputStream inputStream = VirtDataResources.findRequiredStreamOrFile(string, "", DATA_DIR);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            List<String> list2;
            list = list2 = bufferedReader.lines().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error while reading required file to string", iOException);
            }
        }
        bufferedReader.close();
        return list;
    }

    public static String readFileString(String string, String ... stringArray) {
        String string2;
        InputStream inputStream = VirtDataResources.findRequiredStreamOrFile(string, "", stringArray);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string3;
            string2 = string3 = bufferedReader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error while reading required file to string", iOException);
            }
        }
        bufferedReader.close();
        return string2;
    }

    public static CSVParser readFileCSV(String string, String ... stringArray) {
        Reader reader = VirtDataResources.findRequiredReader(string, "csv", stringArray);
        CSVFormat cSVFormat = CSVFormat.newFormat(',').withFirstRecordAsHeader();
        try {
            CSVParser cSVParser = new CSVParser(reader, cSVFormat);
            return cSVParser;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static CharBuffer loadFileToCharBuffer(String string, String ... stringArray) {
        CharBuffer charBuffer;
        InputStream inputStream = VirtDataResources.findRequiredStreamOrFile(string, "", stringArray);
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            charBuffer = CharBuffer.allocate(0x100000);
            while (inputStreamReader.read(charBuffer) > 0) {
            }
            inputStreamReader.close();
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage());
            throw new RuntimeException(iOException);
        }
        charBuffer.flip();
        return charBuffer.asReadOnlyBuffer();
    }

    public static Path findPathIn(String ... stringArray) {
        for (String string : stringArray) {
            Path path = null;
            if (VirtDataResources.isRemote(string)) {
                try {
                    Optional<InputStream> optional = VirtDataResources.getInputStreamForUrl(string);
                    if (optional.isPresent()) {
                        path = Path.of(URI.create(string));
                        logger.debug("Found accessible remote file at " + path.toString());
                    }
                }
                catch (Exception exception) {}
            } else {
                Object object;
                Object object2;
                boolean bl = string.endsWith(FileSystems.getDefault().getSeparator());
                String string2 = bl ? string.substring(0, string.length() - 1) : string;
                Path path2 = Path.of(string2, new String[0]);
                try {
                    object2 = path2.getFileSystem().provider();
                    ((FileSystemProvider)object2).checkAccess(path2, AccessMode.READ);
                    object = ((FileSystemProvider)object2).readAttributes(path2, BasicFileAttributes.class, new LinkOption[0]);
                    boolean bl2 = object.isDirectory();
                    if (bl != bl2) {
                        throw new RuntimeException("for path " + string + ", user wanted a " + (bl ? "directory" : "file") + ", but found a " + (bl2 ? "directory" : "file") + " while searching paths " + Arrays.toString(stringArray));
                    }
                    path = path2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (path == null) {
                    try {
                        object2 = ClassLoader.getSystemResource(string2);
                        if (object2 != null) {
                            object = URI.create(((URL)object2).toExternalForm());
                            path = VirtDataResources.getPathInFilesystem((URI)object);
                            logger.debug("Found path in classpath: " + string2 + ": " + path.toString());
                        }
                    }
                    catch (Exception exception) {
                        logger.trace("Error while looking in classpath for " + exception.getMessage(), exception);
                    }
                }
            }
            if (path == null) continue;
            return path;
        }
        throw new RuntimeException("Unable to find path in " + Arrays.toString(stringArray));
    }

    private static synchronized Path getPathInFilesystem(URI uRI) {
        FileSystem fileSystem = null;
        try {
            fileSystem = FileSystems.getFileSystem(uRI);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            try {
                fileSystem = FileSystems.newFileSystem(uRI, new HashMap());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return Path.of(uRI);
    }

    public static CSVParser readDelimFile(String string, char c, String ... stringArray) {
        Reader reader = VirtDataResources.findRequiredReader(string, "csv", stringArray);
        CSVFormat cSVFormat = CSVFormat.newFormat(c).withFirstRecordAsHeader();
        try {
            CSVParser cSVParser = new CSVParser(reader, cSVFormat);
            return cSVParser;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

