/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.processors;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFunc;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import io.virtdata.processors.FuncEnumerator;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;

public class FunctionDocInfoWriter
implements FuncEnumerator.Listener {
    private final String suffix;
    private Filer filer;
    private Messager messenger;

    public FunctionDocInfoWriter(Filer filer, Messager messenger, String suffix) {
        this.filer = filer;
        this.messenger = messenger;
        this.suffix = suffix;
    }

    @Override
    public void onFunctionModel(DocForFunc functionDoc) {
        TypeSpec typeSpec = this.createInlineClassForDocFuncData(functionDoc, functionDoc.getClassName() + this.suffix);
        JavaFile javafile = JavaFile.builder((String)functionDoc.getPackageName(), (TypeSpec)typeSpec).addFileComment("This file is auto-generated.", new Object[0]).build();
        try {
            javafile.writeTo(this.filer);
        }
        catch (IOException e) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, "Error writing javafile " + javafile.packageName + "." + javafile.typeSpec.toString());
            throw new RuntimeException(e);
        }
    }

    private TypeSpec createInlineClassForDocFuncData(DocForFunc doc, String newClassName) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        MethodSpec getClassName = MethodSpec.methodBuilder((String)"getClassName").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $S", new Object[]{doc.getClassName()}).build();
        methods.add(getClassName);
        MethodSpec getPackageName = MethodSpec.methodBuilder((String)"getPackageName").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $S", new Object[]{doc.getPackageName()}).build();
        methods.add(getPackageName);
        MethodSpec getClassJavaDoc = MethodSpec.methodBuilder((String)"getClassJavadoc").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $S", new Object[]{doc.getClassJavadoc()}).build();
        methods.add(getClassJavaDoc);
        MethodSpec getInType = MethodSpec.methodBuilder((String)"getInType").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $S", new Object[]{doc.getInType()}).build();
        methods.add(getInType);
        MethodSpec getOutType = MethodSpec.methodBuilder((String)"getOutType").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $S", new Object[]{doc.getOutType()}).build();
        methods.add(getOutType);
        CodeBlock ctorsHead = CodeBlock.builder().add("return new $T<$T>() {{$>\n", new Object[]{ArrayList.class, DocCtorData.class}).build();
        CodeBlock ctorsTail = CodeBlock.builder().add("$<}}", new Object[0]).build();
        CodeBlock.Builder ctors = CodeBlock.builder().add(ctorsHead);
        for (DocCtorData ctor : doc.getCtors()) {
            ctors.add("add(new $T($S, $S, \n$>new $T<String, String>() {{\n$>", new Object[]{DocForFuncCtor.class, ctor.getClassName(), ctor.getCtorJavaDoc(), LinkedHashMap.class});
            for (Map.Entry arg : ctor.getArgs().entrySet()) {
                ctors.add("put($S,$S);\n", new Object[]{arg.getKey(), arg.getValue()});
            }
            ctors.add("$<}},\n", new Object[0]);
            ctors.add("new $T<$T<$T>>() {{\n$>", new Object[]{ArrayList.class, List.class, String.class});
            for (List example : ctor.getExamples()) {
                ctors.add("add(new $T<$T>() {{$>\n", new Object[]{ArrayList.class, String.class});
                for (String s : example) {
                    ctors.add("add(\"" + s + "\");\n", new Object[0]);
                }
                ctors.add("$<}});\n", new Object[0]);
            }
            ctors.add("$<}}", new Object[0]);
            ctors.add("\n$<));\n", new Object[0]);
        }
        ctors.add(ctorsTail);
        MethodSpec getCategoriesMethod = MethodSpec.methodBuilder((String)"getCategories").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ArrayTypeName.of(Category.class)).addStatement("return new $T[] { " + Arrays.stream(doc.getCategories()).map(c -> "Category." + c).collect(Collectors.joining(",")) + " }", new Object[]{Category.class}).build();
        methods.add(getCategoriesMethod);
        MethodSpec getCtorsMethod = MethodSpec.methodBuilder((String)"getCtors").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{DocCtorData.class})).addStatement(ctors.build()).build();
        methods.add(getCtorsMethod);
        AnnotationSpec serviceAnnotation = AnnotationSpec.builder(Service.class).addMember("value", "$T.class", new Object[]{DocFuncData.class}).build();
        TypeSpec manifestType = TypeSpec.classBuilder((String)newClassName).addAnnotation(serviceAnnotation).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethods(methods).addSuperinterface(DocFuncData.class).build();
        return manifestType;
    }
}

