/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.processors;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.virtdata.annotations.Category;
import io.virtdata.annotations.Service;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFunc;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import io.virtdata.processors.FuncEnumerator;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;

public class FunctionDocInfoWriter
implements FuncEnumerator.Listener {
    private final String suffix;
    private Filer filer;
    private Messager messenger;

    public FunctionDocInfoWriter(Filer filer, Messager messager, String string) {
        this.filer = filer;
        this.messenger = messager;
        this.suffix = string;
    }

    @Override
    public void onFunctionModel(DocForFunc docForFunc) {
        TypeSpec typeSpec = this.createInlineClassForDocFuncData(docForFunc, docForFunc.getClassName() + this.suffix);
        JavaFile javaFile = JavaFile.builder((String)docForFunc.getPackageName(), (TypeSpec)typeSpec).addFileComment("This file is auto-generated.", new Object[0]).build();
        try {
            javaFile.writeTo(this.filer);
        }
        catch (IOException iOException) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, "Error writing javafile " + javaFile.packageName + "." + javaFile.typeSpec.toString());
            throw new RuntimeException(iOException);
        }
    }

    private TypeSpec createInlineClassForDocFuncData(DocForFunc docForFunc, String string) {
        DocCtorData docCtorData22;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"getClassName").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $S", new Object[]{docForFunc.getClassName()}).build();
        arrayList.add(methodSpec);
        MethodSpec methodSpec2 = MethodSpec.methodBuilder((String)"getPackageName").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $S", new Object[]{docForFunc.getPackageName()}).build();
        arrayList.add(methodSpec2);
        MethodSpec methodSpec3 = MethodSpec.methodBuilder((String)"getClassJavadoc").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $S", new Object[]{docForFunc.getClassJavadoc()}).build();
        arrayList.add(methodSpec3);
        MethodSpec methodSpec4 = MethodSpec.methodBuilder((String)"getInType").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $S", new Object[]{docForFunc.getInType()}).build();
        arrayList.add(methodSpec4);
        MethodSpec methodSpec5 = MethodSpec.methodBuilder((String)"getOutType").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $S", new Object[]{docForFunc.getOutType()}).build();
        arrayList.add(methodSpec5);
        CodeBlock codeBlock = CodeBlock.builder().add("return new $T<$T>() {{$>\n", new Object[]{ArrayList.class, DocCtorData.class}).build();
        CodeBlock codeBlock2 = CodeBlock.builder().add("$<}}", new Object[0]).build();
        CodeBlock.Builder builder = CodeBlock.builder().add(codeBlock);
        for (DocCtorData docCtorData22 : docForFunc.getCtors()) {
            builder.add("add(new $T($S, $S, \n$>new $T<String, String>() {{\n$>", new Object[]{DocForFuncCtor.class, docCtorData22.getClassName(), docCtorData22.getCtorJavaDoc(), LinkedHashMap.class});
            for (Map.Entry entry : docCtorData22.getArgs().entrySet()) {
                builder.add("put($S,$S);\n", new Object[]{entry.getKey(), entry.getValue()});
            }
            builder.add("$<}},\n", new Object[0]);
            builder.add("new $T<$T<$T>>() {{\n$>", new Object[]{ArrayList.class, List.class, String.class});
            for (List list : docCtorData22.getExamples()) {
                builder.add("add(new $T<$T>() {{$>\n", new Object[]{ArrayList.class, String.class});
                for (String string2 : list) {
                    builder.add("add(\"" + string2 + "\");\n", new Object[0]);
                }
                builder.add("$<}});\n", new Object[0]);
            }
            builder.add("$<}}", new Object[0]);
            builder.add("\n$<));\n", new Object[0]);
        }
        builder.add(codeBlock2);
        MethodSpec methodSpec6 = MethodSpec.methodBuilder((String)"getCategories").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ArrayTypeName.of(Category.class)).addStatement("return new $T[] { " + Arrays.stream(docForFunc.getCategories()).map(category -> "Category." + category).collect(Collectors.joining(",")) + " }", new Object[]{Category.class}).build();
        arrayList.add(methodSpec6);
        docCtorData22 = MethodSpec.methodBuilder((String)"getCtors").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{DocCtorData.class})).addStatement(builder.build()).build();
        arrayList.add(docCtorData22);
        Iterator iterator = AnnotationSpec.builder(Service.class).addMember("value", "$T.class", new Object[]{DocFuncData.class}).build();
        TypeSpec typeSpec = TypeSpec.classBuilder((String)string).addAnnotation(iterator).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethods(arrayList).addSuperinterface(DocFuncData.class).build();
        return typeSpec;
    }
}

