/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.valuesapp;

import io.virtdata.api.DataMapper;
import io.virtdata.core.VirtData;
import io.virtdata.valuesapp.IndexedThreadFactory;
import io.virtdata.valuesapp.RunData;
import io.virtdata.valuesapp.ValuesCheckerExceptionHandler;
import io.virtdata.valuesapp.ValuesCheckerRunnable;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesCheckerCoordinator
implements Callable<RunData> {
    private static final Logger logger = LoggerFactory.getLogger(ValuesCheckerCoordinator.class);
    private final String specifier;
    private final int threads;
    private final int bufsize;
    private final long end;
    private final long start;
    private final boolean isolated;
    private final ReentrantLock lock;
    private final Condition goTime;
    private final ConcurrentLinkedDeque<Throwable> errors = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedQueue<Integer> readyQueue = new ConcurrentLinkedQueue();
    ExecutorService pool;
    private long genTimeAccumulator = 0L;
    private long cmpTimeAccumulator = 0L;

    public ValuesCheckerCoordinator(String specifier, int threads, int bufsize, long start, long end, boolean isolated) {
        this.specifier = specifier;
        this.threads = threads;
        this.bufsize = bufsize;
        this.start = start;
        this.end = end;
        this.isolated = isolated;
        this.lock = new ReentrantLock();
        this.goTime = this.lock.newCondition();
    }

    public void run() {
        this.testConcurrentValues(this.threads, this.start, this.end, this.specifier);
        if (this.errors.size() > 0) {
            for (Throwable error : this.errors) {
                System.out.println(error.getMessage());
            }
            throw new RuntimeException("Errors in verification: " + this.errors);
        }
    }

    private void testConcurrentValues(int threads, long start, long end, String mapperSpec) {
        DataMapper mapper = (DataMapper)VirtData.getMapper((String)this.specifier).orElseThrow(() -> new RuntimeException("Unable to map function for specifier: " + this.specifier));
        CopyOnWriteArrayList<Object> reference = new CopyOnWriteArrayList<Object>();
        ValuesCheckerExceptionHandler valuesCheckerExceptionHandler = new ValuesCheckerExceptionHandler(this);
        IndexedThreadFactory tf = new IndexedThreadFactory("values-checker", valuesCheckerExceptionHandler);
        this.pool = Executors.newFixedThreadPool(threads, tf);
        logger.info("Checking [{}..{}) in chunks of {}", new Object[]{start, end, this.bufsize});
        if (!this.isolated) {
            logger.debug("Sharing data mapper, only expect success for explicitly thread-safe generators.");
        }
        for (int t = 0; t < threads; ++t) {
            ValuesCheckerRunnable runnable;
            if (this.isolated) {
                runnable = new ValuesCheckerRunnable(start, end, this.bufsize, t, mapperSpec, null, this.readyQueue, this.goTime, this.lock, reference);
            } else {
                DataMapper threadMapper = (DataMapper)VirtData.getMapper((String)mapperSpec).orElseThrow(() -> new RuntimeException("Unable to map function for specifier: " + this.specifier));
                runnable = new ValuesCheckerRunnable(start, end, this.bufsize, t, null, threadMapper, this.readyQueue, this.goTime, this.lock, reference);
            }
            this.pool.execute(runnable);
        }
        logger.info("starting generation loops...");
        for (long intervalStart = 0L; intervalStart < end - start; intervalStart += (long)this.bufsize) {
            String rangeInfo = "[" + intervalStart + ".." + (intervalStart + (long)this.bufsize) + ")";
            long genStart = System.nanoTime();
            this.coordinateFor("generation start " + rangeInfo);
            this.throwInjectedExceptions();
            this.coordinateFor("generation complete " + rangeInfo);
            long genStop = System.nanoTime();
            long genTime = genStop - genStart;
            this.genTimeAccumulator += genTime;
            this.throwInjectedExceptions();
            System.out.print(".");
            System.out.flush();
            long cmpStart = System.nanoTime();
            this.coordinateFor("verification start " + rangeInfo);
            this.throwInjectedExceptions();
            this.coordinateFor("verification complete " + rangeInfo);
            long cmpEnd = System.nanoTime();
            long cmpTime = cmpEnd - cmpStart;
            this.cmpTimeAccumulator += cmpTime;
            this.throwInjectedExceptions();
            System.out.print(".");
            System.out.flush();
        }
        System.out.println("\n");
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(60000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private synchronized void throwInjectedExceptions() {
        if (this.errors.peekFirst() != null) {
            int count = 0;
            for (Throwable error : this.errors) {
                System.out.print("EXCEPTION " + count++ + ": ");
                System.out.println(error.getMessage());
            }
            throw new RuntimeException(this.errors.peekFirst());
        }
    }

    synchronized void handleException(Thread t, Throwable e) {
        this.errors.add(e);
        if (this.pool != null) {
            this.pool.shutdownNow();
        }
    }

    private void coordinateFor(String forWhat) {
        logger.trace("coordinating " + this.threads + " threads for " + forWhat);
        try {
            long delay = 1L;
            while (this.readyQueue.size() < this.threads) {
                Thread.sleep(delay);
                delay = Math.min(1024L, delay * 2L);
                this.throwInjectedExceptions();
            }
            this.readyQueue.clear();
            this.lock.lock();
            this.goTime.signalAll();
        }
        catch (Exception e) {
            logger.error("Error while signaling threads: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public RunData call() throws Exception {
        this.run();
        return new RunData(this.specifier, this.threads, this.start, this.end, this.bufsize, this.isolated, (double)this.genTimeAccumulator / 1000000.0, (double)this.cmpTimeAccumulator / 1000000.0);
    }
}

