/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.apps.docsapp;

import io.virtdata.annotations.Category;
import io.virtdata.core.VirtDataDocs;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocFuncData;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocsApp {
    private static final Logger logger = LoggerFactory.getLogger(DocsApp.class);
    private static final String SPLIT = "split";
    private static final String COMBINED = "combined";
    private static final String ALL = "all";
    private static final String DEFAULT_FILE = "funcref";
    private static final String fileExtension = ".md";
    private Map<Category, Map<String, List<DocFuncData>>> groupedModels = new HashMap<Category, Map<String, List<DocFuncData>>>();
    private String baseFileName = "funcref";
    private String print = "all";
    private String categories = "split";

    public static void main(String[] args) {
        new DocsApp().invoke(args);
    }

    private void invoke(String[] args) {
        Object group;
        LinkedList<String> largs = new LinkedList<String>(Arrays.asList(args));
        while (largs.peekFirst() != null) {
            String argtype = largs.removeFirst();
            if (largs.peekFirst() == null) {
                throw new RuntimeException(DocsApp.class.toString() + " expects args in param value couplets.");
            }
            String argval = largs.removeFirst().toLowerCase();
            switch (argtype) {
                case "output": {
                    this.baseFileName = argval;
                    break;
                }
                case "print": {
                    if (argval.equals(ALL) || argval.equals("logs")) {
                        this.print = argval;
                    } else {
                        throw new InvalidParameterException("valid args for print: print all, print logs");
                    }
                }
                case "categories": {
                    if (!argval.equals(SPLIT) && !argval.equals(COMBINED)) {
                        throw new RuntimeException("categories must either be split, or combined.");
                    }
                    this.categories = argval;
                    break;
                }
            }
        }
        List docModels = VirtDataDocs.getAllDocs();
        for (DocFuncData docModel : docModels) {
            for (Category category : docModel.getCategories()) {
                Map<String, List<DocFuncData>> category_funcname_list = this.groupedModels.get(category);
                if (category_funcname_list == null) {
                    category_funcname_list = new HashMap<String, List<DocFuncData>>();
                    this.groupedModels.put(category, category_funcname_list);
                }
                group = category_funcname_list.getOrDefault(docModel.getClassName(), new ArrayList());
                group.add(docModel);
                category_funcname_list.put(docModel.getClassName(), (List<DocFuncData>)group);
            }
        }
        StringBuilder sb = new StringBuilder();
        HashMap<String, Set> assignments = new HashMap<String, Set>();
        for (DocFuncData docModel : docModels) {
            Set listForFuncName = assignments.getOrDefault(docModel.getClassName(), new HashSet());
            assignments.put(docModel.getClassName(), listForFuncName);
            if (listForFuncName.size() > 0) {
                logger.warn("Func name " + docModel.getClassName() + " has " + listForFuncName.size() + " multiple category annotations:");
            }
            listForFuncName.addAll(Arrays.asList(docModel.getCategories()));
            logger.info("Assigning " + docModel.getClassName() + " to categories " + listForFuncName.toString());
        }
        HashSet<Category> generalSet = new HashSet<Category>(){
            {
                this.add(Category.general);
            }
        };
        HashMap<Category, Map<String, List<DocFuncData>>> regrouped = new HashMap<Category, Map<String, List<DocFuncData>>>();
        for (DocFuncData docModel : docModels) {
            Object assignment = (Category[])assignments.getOrDefault(docModel.getClassName(), generalSet);
            if (assignment.size() == 0) {
                assignment = generalSet;
            }
            logger.info("looking up assignment for " + docModel.getClassName() + ":" + assignment.toString());
            group = assignment.iterator();
            while (group.hasNext()) {
                Category category = (Category)group.next();
                Map assignToCategory = regrouped.getOrDefault(category, new HashMap());
                regrouped.put(category, assignToCategory);
                List assignToClass = assignToCategory.getOrDefault(docModel.getClassName(), new ArrayList());
                assignToCategory.put(docModel.getClassName(), assignToClass);
                assignToClass.add(docModel);
            }
        }
        this.groupedModels = regrouped;
        HashMap writers = new HashMap();
        Writer writer = new OutputStreamWriter(System.out);
        try {
            for (Category category : Category.values()) {
                if (!this.groupedModels.keySet().contains(category)) continue;
                if (!this.baseFileName.isEmpty() && this.categories.equals(SPLIT)) {
                    writer = writers.getOrDefault(category.toString(), new FileWriter(this.baseFileName + "_" + category.toString() + fileExtension));
                } else if (!this.baseFileName.isEmpty() && this.categories.equals(COMBINED)) {
                    writer = writers.getOrDefault(this.baseFileName + fileExtension, new FileWriter(this.baseFileName));
                }
                String docs = this.writeCategoryDocs(category, this.groupedModels.get(category));
                docs = this.replacePatterns(docs);
                writer.write(docs);
                ((Writer)writer).flush();
            }
            for (Writer writer1 : writers.values()) {
                writer1.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String replacePatterns(String docdata) {
        docdata = docdata.replaceAll("java.lang.", "");
        docdata = docdata.replaceAll("\\s*</?pre>\\s*\n", "\n```\n");
        docdata = docdata.replaceAll("(<p>|</p>| \n)+", "\n");
        docdata = docdata.replaceAll("<pre>", "`").replaceAll("</pre>", "`");
        docdata = docdata.replaceAll("\\{@link (.+?)}", "$1");
        docdata = docdata.replaceAll("(?m)@param .*\n", "");
        docdata = docdata.replaceAll("(?m)\n\n+", "\n\n");
        return docdata;
    }

    private String writeCategoryDocs(Category category, Map<String, List<DocFuncData>> groupedDocs) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> funcNames = new ArrayList<String>(groupedDocs.keySet());
        Collections.sort(funcNames);
        sb.append("# CATEGORY ").append(category).append("\n");
        for (String name : funcNames) {
            List<DocFuncData> docs = groupedDocs.get(name);
            sb.append("## ").append(name).append("\n\n");
            List classdocs = docs.stream().filter(d -> d.getClassJavadoc() != null && !d.getClassJavadoc().isEmpty()).collect(Collectors.toList());
            List distinctClassDocs = classdocs.stream().map(DocFuncData::getClassJavadoc).map(String::trim).distinct().collect(Collectors.toList());
            if (distinctClassDocs.size() == 0) {
                logger.warn("There were no class docs found for types named " + name);
            }
            if (distinctClassDocs.size() > 1) {
                logger.warn("There were multiple class docs found for types named " + name);
            }
            if (distinctClassDocs.size() == 1) {
                String classdoc = (String)distinctClassDocs.get(0);
                sb.append(classdoc);
                if (!classdoc.endsWith("\n\n")) {
                    sb.append("\n");
                }
                if (!classdoc.endsWith("\n")) {
                    sb.append("\n");
                }
            }
            for (DocFuncData doc : docs) {
                List ctors = doc.getCtors();
                for (DocCtorData ctor : ctors) {
                    sb.append("- ").append(doc.getInType()).append(" -> ");
                    sb.append(doc.getClassName());
                    sb.append("(");
                    sb.append(ctor.getArgs().entrySet().stream().map(e -> (String)e.getValue() + ": " + (String)e.getKey()).collect(Collectors.joining(", ")));
                    sb.append(")");
                    sb.append(" -> ").append(doc.getOutType()).append("\n");
                    String ctorDoc = ctor.getCtorJavaDoc();
                    if (!ctorDoc.isEmpty()) {
                        sb.append("  - *notes:* ").append(ctorDoc);
                    }
                    for (List example : ctor.getExamples()) {
                        sb.append("  - *ex:* `").append((String)example.get(0)).append("`");
                        if (example.size() > 1) {
                            sb.append(" - *").append((String)example.get(1)).append("*");
                        }
                        sb.append("\n");
                    }
                }
            }
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }
}

