/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api.composers;

import io.virtdata.api.FunctionType;
import io.virtdata.api.composers.ComposerForDoubleFunction;
import io.virtdata.api.composers.ComposerForDoubleToIntFunction;
import io.virtdata.api.composers.ComposerForDoubleToLongFunction;
import io.virtdata.api.composers.ComposerForDoubleUnaryOperator;
import io.virtdata.api.composers.ComposerForFunction;
import io.virtdata.api.composers.ComposerForIntFunction;
import io.virtdata.api.composers.ComposerForIntToDoubleFunction;
import io.virtdata.api.composers.ComposerForIntToLongFunction;
import io.virtdata.api.composers.ComposerForIntUnaryOperator;
import io.virtdata.api.composers.ComposerForLongFunction;
import io.virtdata.api.composers.ComposerForLongToDoubleFunction;
import io.virtdata.api.composers.ComposerForLongToIntFunction;
import io.virtdata.api.composers.ComposerForLongUnaryOperator;
import io.virtdata.api.composers.FunctionComposer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionAssembly
implements FunctionComposer {
    private static final Logger logger = LoggerFactory.getLogger(FunctionAssembly.class);
    private FunctionComposer<?> composer = null;

    @Override
    public Object getFunctionObject() {
        if (this.composer != null) {
            return this.composer.getFunctionObject();
        }
        throw new RuntimeException("No function have been passed for assembly.");
    }

    @Override
    public FunctionComposer andThen(Object outer) {
        try {
            this.composer = this.composer != null ? this.composer.andThen(outer) : this.andThenInitial(outer);
            return this.composer;
        }
        catch (Exception e) {
            logger.error("Error while composing functions:\n");
            if (this.composer != null) {
                logger.error("composer: class:" + this.composer.getClass().getSimpleName() + ", toString:" + this.composer.toString());
            }
            logger.error("outer: class:" + outer.getClass() + ", toString:" + outer.toString());
            throw e;
        }
    }

    private FunctionComposer<?> andThenInitial(Object o) {
        try {
            FunctionType functionType = FunctionType.valueOf(o);
            switch (functionType) {
                case long_long: {
                    return new ComposerForLongUnaryOperator((LongUnaryOperator)o);
                }
                case long_int: {
                    return new ComposerForLongToIntFunction((LongToIntFunction)o);
                }
                case long_double: {
                    return new ComposerForLongToDoubleFunction((LongToDoubleFunction)o);
                }
                case long_T: {
                    return new ComposerForLongFunction((LongFunction)o);
                }
                case int_int: {
                    return new ComposerForIntUnaryOperator((IntUnaryOperator)o);
                }
                case int_long: {
                    return new ComposerForIntToLongFunction((IntToLongFunction)o);
                }
                case int_double: {
                    return new ComposerForIntToDoubleFunction((IntToDoubleFunction)o);
                }
                case int_T: {
                    return new ComposerForIntFunction((IntFunction)o);
                }
                case double_double: {
                    return new ComposerForDoubleUnaryOperator((DoubleUnaryOperator)o);
                }
                case double_long: {
                    return new ComposerForDoubleToLongFunction((DoubleToLongFunction)o);
                }
                case double_int: {
                    return new ComposerForDoubleToIntFunction((DoubleToIntFunction)o);
                }
                case double_T: {
                    return new ComposerForDoubleFunction((DoubleFunction)o);
                }
                case R_T: {
                    return new ComposerForFunction((Function)o);
                }
            }
            throw new RuntimeException("Unrecognized function type:" + (Object)((Object)functionType));
        }
        catch (Exception e) {
            logger.error("Error while setting up initial composer state for function class:" + o.getClass().getSimpleName() + ", toString:" + o.toString());
            throw e;
        }
    }
}

