/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.basicsmappers.from_long.to_long;

import io.virtdata.annotations.Category;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocForFuncCtor;
import io.virtdata.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ShuffleAutoDocsInfo
implements DocFuncData {
    @Override
    public String getClassName() {
        return "Shuffle";
    }

    @Override
    public String getPackageName() {
        return "io.virtdata.basicsmappers.from_long.to_long";
    }

    @Override
    public String getClassJavadoc() {
        return "This function provides a low-overhead shuffling effect without loading\nelements into memory. It uses a bundled dataset of pre-computed\nGalois LFSR shift register configurations, along with a down-sampling\nmethod to provide amortized virtual shuffling with minimal memory usage.\n\nEssentially, this guarantees that every value in the specified range will\nbe seen at least once before the cycle repeats. However, since the order\nof traversal of these values is dependent on the LFSR configuration, some\norders will appear much more random than others depending on where you\nare in the traversal cycle.\n\nThis function *does* yield values that are deterministic.\n";
    }

    @Override
    public String getInType() {
        return "long";
    }

    @Override
    public String getOutType() {
        return "long";
    }

    @Override
    public Category[] getCategories() {
        return new Category[0];
    }

    @Override
    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("Shuffle", "", (Map<String, String>)new LinkedHashMap<String, String>(){
                    {
                        this.put("min", "long");
                        this.put("maxPlusOne", "long");
                    }
                }, (List<List<String>>)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("Shuffle(11,99)");
                                this.add("Provide all values between 11 and 98 inclusive, in some order, then repeat");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("Shuffle", "", (Map<String, String>)new LinkedHashMap<String, String>(){
                    {
                        this.put("min", "long");
                        this.put("maxPlusOne", "long");
                        this.put("bankSelector", "int");
                    }
                }, (List<List<String>>)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("Shuffle(11,99,3)");
                                this.add("Provide all values between 11 and 98 inclusive, in some different (and repeatable) order, then repeat");
                            }
                        });
                    }
                }));
            }
        };
    }
}

