/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.continuous.long_double;

import io.virtdata.continuous.common.InterpolatingLongDoubleSampler;
import io.virtdata.continuous.common.RealDistributionICDSource;
import io.virtdata.continuous.common.RealLongDoubleSampler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.LongToDoubleFunction;
import org.apache.commons.statistics.distribution.ContinuousDistribution;

public class LongToDoubleContinuousCurve
implements LongToDoubleFunction {
    private ContinuousDistribution distribution;
    private LongToDoubleFunction function;
    public static final String COMPUTE = "compute";
    public static final String INTERPOLATE = "interpolate";
    public static final String MAP = "map";
    public static final String HASH = "hash";
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add(LongToDoubleContinuousCurve.COMPUTE);
            this.add(LongToDoubleContinuousCurve.INTERPOLATE);
            this.add(LongToDoubleContinuousCurve.MAP);
            this.add(LongToDoubleContinuousCurve.HASH);
        }
    };

    public LongToDoubleContinuousCurve(ContinuousDistribution distribution, String ... modslist) {
        this.distribution = distribution;
        HashSet<String> mods = new HashSet<String>(Arrays.asList(modslist));
        RealDistributionICDSource icdSource = new RealDistributionICDSource(distribution);
        if (mods.contains(HASH) && mods.contains(MAP)) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (mods.contains(INTERPOLATE) && mods.contains(COMPUTE)) {
            throw new RuntimeException("mods must not contain both interpolate and compute");
        }
        for (String s : modslist) {
            if (validModifiers.contains(s)) continue;
            throw new RuntimeException("modifier '" + s + "' is not a valid modifier. Use one of " + validModifiers.toString() + " instead.");
        }
        boolean hash = mods.contains(HASH) || !mods.contains(MAP);
        boolean interpolate = mods.contains(INTERPOLATE) || !mods.contains(COMPUTE);
        this.function = interpolate ? new InterpolatingLongDoubleSampler(icdSource, 1000, hash) : new RealLongDoubleSampler(icdSource, hash);
    }

    @Override
    public double applyAsDouble(long value) {
        return this.function.applyAsDouble(value);
    }
}

