/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.processors;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"io.virtdata.annotations.Service"})
public class ServiceProcessor
extends AbstractProcessor {
    private static Pattern packageNamePattern = Pattern.compile("(?<packageName>.+)?\\.(?<className>.+)");
    private Filer filer;
    private Map<String, String> options;
    private Elements elementUtils;
    private Messager messenger;
    private SourceVersion sourceVersion;
    private Types typeUtils;
    private Map<String, Writer> writers = new HashMap<String, Writer>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.options = processingEnv.getOptions();
        this.elementUtils = processingEnv.getElementUtils();
        this.messenger = processingEnv.getMessager();
        this.sourceVersion = processingEnv.getSourceVersion();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    private Writer getWriterForClass(Class<?> clazz, Element ... elements) {
        String serviceName = clazz.getCanonicalName();
        return this.writers.computeIfAbsent(serviceName, s -> {
            try {
                return this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + s, elements).openWriter();
            }
            catch (IOException e) {
                this.messenger.printMessage(Diagnostic.Kind.ERROR, e.toString());
                return null;
            }
        });
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList ts = new ArrayList();
        try {
            for (String annotationType : this.getSupportedAnnotationTypes()) {
                Class<?> annotationClass = Class.forName(annotationType);
                Set<? extends Element> tsms = roundEnv.getElementsAnnotatedWith(annotationClass);
                for (Element element : tsms) {
                    for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                        if (!annotationMirror.getAnnotationType().toString().equals("io.virtdata.annotations.Service")) continue;
                        if (annotationMirror.getElementValues().size() == 1) {
                            AnnotationValue annotationValue = annotationMirror.getElementValues().get("0");
                            continue;
                        }
                        this.messenger.printMessage(Diagnostic.Kind.ERROR, element.toString() + " should have one service interface name");
                    }
                }
                if (tsms.size() <= 0) continue;
                Writer w = this.getWriterForClass(annotationClass, tsms.toArray(new Element[0]));
                for (Element element : tsms) {
                    w.write(((TypeElement)element).getQualifiedName() + "\n");
                }
            }
            for (Writer writer : this.writers.values()) {
                writer.close();
            }
        }
        catch (Exception e) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, e.toString());
        }
        return true;
    }
}

