/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.apache.commons.rng.core.source32.IntProvider;

public class JDKRandom
extends IntProvider {
    private Random delegate;

    public JDKRandom(Long seed) {
        this.delegate = new Random(seed);
    }

    @Override
    public int next() {
        return this.delegate.nextInt();
    }

    @Override
    protected byte[] getStateInternal() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this.delegate);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void setStateInternal(byte[] s) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(s);
            ObjectInputStream ois = new ObjectInputStream(bis);
            this.delegate = (Random)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

