/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class RejectionInversionZipfSampler
extends SamplerBase
implements DiscreteSampler {
    private static final double TAYLOR_THRESHOLD = 1.0E-8;
    private static final double F_1_2 = 0.5;
    private static final double F_1_3 = 0.3333333333333333;
    private static final double F_1_4 = 0.25;
    private final int numberOfElements;
    private final double exponent;
    private final double hIntegralX1;
    private final double hIntegralNumberOfElements;
    private final double s;

    public RejectionInversionZipfSampler(UniformRandomProvider rng, int numberOfElements, double exponent) {
        super(rng);
        if (numberOfElements <= 0) {
            throw new IllegalArgumentException("number of elements is not strictly positive: " + numberOfElements);
        }
        if (exponent <= 0.0) {
            throw new IllegalArgumentException("exponent is not strictly positive: " + exponent);
        }
        this.numberOfElements = numberOfElements;
        this.exponent = exponent;
        this.hIntegralX1 = this.hIntegral(1.5) - 1.0;
        this.hIntegralNumberOfElements = this.hIntegral((double)numberOfElements + 0.5);
        this.s = 2.0 - this.hIntegralInverse(this.hIntegral(2.5) - this.h(2.0));
    }

    @Override
    public int sample() {
        double u;
        double x;
        int k;
        do {
            if ((k = (int)((x = this.hIntegralInverse(u = this.hIntegralNumberOfElements + this.nextDouble() * (this.hIntegralX1 - this.hIntegralNumberOfElements))) + 0.5)) < 1) {
                k = 1;
                continue;
            }
            if (k <= this.numberOfElements) continue;
            k = this.numberOfElements;
        } while (!((double)k - x <= this.s) && !(u >= this.hIntegral((double)k + 0.5) - this.h(k)));
        return k;
    }

    @Override
    public String toString() {
        return "Rejection inversion Zipf deviate [" + super.toString() + "]";
    }

    private double hIntegral(double x) {
        double logX = Math.log(x);
        return RejectionInversionZipfSampler.helper2((1.0 - this.exponent) * logX) * logX;
    }

    private double h(double x) {
        return Math.exp(-this.exponent * Math.log(x));
    }

    private double hIntegralInverse(double x) {
        double t = x * (1.0 - this.exponent);
        if (t < -1.0) {
            t = -1.0;
        }
        return Math.exp(RejectionInversionZipfSampler.helper1(t) * x);
    }

    private static double helper1(double x) {
        if (Math.abs(x) > 1.0E-8) {
            return Math.log1p(x) / x;
        }
        return 1.0 - x * (0.5 - x * (0.3333333333333333 - 0.25 * x));
    }

    private static double helper2(double x) {
        if (Math.abs(x) > 1.0E-8) {
            return Math.expm1(x) / x;
        }
        return 1.0 + x * 0.5 * (1.0 + x * 0.3333333333333333 * (1.0 + 0.25 * x));
    }
}

