/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.apps;

import io.virtdata.apps.VirtDataService;
import io.virtdata.apps.docsapp.AutoDocsApp;
import io.virtdata.apps.valuesapp.ValuesCheckerApp;
import io.virtdata.docsys.core.DocServer;
import java.nio.file.Path;
import java.util.Arrays;

public class MainApp {
    private static final String APP_TESTMAPPER = "testmapper";
    private static final String APP_GENDOCS = "gendocs";
    private static final String APP_DOCSERVER = "docserver";

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: app (testmapper|gendocs|docserver)");
            System.exit(0);
        }
        String appSelection = args[0];
        String[] appArgs = new String[]{};
        if (args.length > 1) {
            appArgs = Arrays.copyOfRange(args, 1, args.length);
        }
        if (appSelection.toLowerCase().equals(APP_TESTMAPPER)) {
            ValuesCheckerApp.main(appArgs);
        } else if (appSelection.toLowerCase().equals(APP_GENDOCS)) {
            AutoDocsApp.main(appArgs);
        } else if (appSelection.toLowerCase().equals(APP_DOCSERVER)) {
            DocServer docs = new DocServer().addPaths(new Path[]{Path.of("docs", new String[0]), Path.of("virtdata-docsys/docs", new String[0])}).addWebObject(new Object[]{VirtDataService.class});
            docs.run();
        } else {
            System.err.println("Error in command line. The first argument must be gendocs or testmapper");
        }
    }
}

