/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.apps;

import io.virtdata.apps.docsapp.AutoDocsApp;
import io.virtdata.apps.valuesapp.ValuesCheckerApp;
import io.virtdata.docsys.core.DocServerApp;
import java.util.Arrays;

public class VirtDataMainApp {
    private static final String APP_TESTMAPPER = "testmapper";
    private static final String APP_GENDOCS = "gendocs";
    private static final String APP_DOCSERVER = "docserver";

    public static boolean hasNamedApp(String appname) {
        return appname.equals(APP_TESTMAPPER) || appname.equals(APP_GENDOCS) || appname.equals(APP_DOCSERVER);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: app (testmapper|gendocs|docserver)");
            System.exit(0);
        }
        String appSelection = args[0];
        String[] appArgs = new String[]{};
        if (args.length > 1) {
            appArgs = Arrays.copyOfRange(args, 1, args.length);
        }
        if (appSelection.toLowerCase().equals(APP_TESTMAPPER)) {
            ValuesCheckerApp.main(appArgs);
        } else if (appSelection.toLowerCase().equals(APP_GENDOCS)) {
            AutoDocsApp.main(appArgs);
        } else if (appSelection.toLowerCase().equals(APP_DOCSERVER)) {
            DocServerApp.main((String[])appArgs);
        } else {
            System.err.println("Error in command line. The first argument must be gendocs or testmapper");
        }
    }
}

