/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.apps.docsapp;

import com.vladsch.flexmark.convert.html.FlexmarkHtmlParser;
import io.virtdata.annotations.Category;
import io.virtdata.core.VirtDataDocs;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocFuncData;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoDocsApp {
    private static final Logger logger = LoggerFactory.getLogger(AutoDocsApp.class);
    private static final String SPLIT = "split";
    private static final String COMBINED = "combined";
    private static final String ALL = "all";
    private static final String DEFAULT_FILE = "funcref";
    private static final String fileExtension = ".md";
    private Map<Category, Map<String, List<DocFuncData>>> groupedModels = new HashMap<Category, Map<String, List<DocFuncData>>>();
    private String baseFileName = "funcref";
    private String print = "all";
    private String categories = "split";

    public static void main(String[] stringArray) {
        new AutoDocsApp().invoke(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    private void invoke(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        Object object5;
        Object object6;
        Object object7;
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
        while (linkedList.peekFirst() != null) {
            object7 = linkedList.removeFirst();
            if (linkedList.peekFirst() == null) {
                throw new RuntimeException(AutoDocsApp.class.toString() + " expects args in param value couplets.");
            }
            object6 = linkedList.removeFirst().toLowerCase();
            switch (object7) {
                case "output": {
                    this.baseFileName = object6;
                    break;
                }
                case "print": {
                    if (((String)object6).equals(ALL) || ((String)object6).equals("logs")) {
                        this.print = object6;
                    } else {
                        throw new InvalidParameterException("valid args for print: print all, print logs");
                    }
                }
                case "categories": {
                    if (!((String)object6).equals(SPLIT) && !((String)object6).equals(COMBINED)) {
                        throw new RuntimeException("categories must either be split, or combined.");
                    }
                    this.categories = object6;
                    break;
                }
            }
        }
        object7 = VirtDataDocs.getAllDocs();
        object6 = object7.iterator();
        while (object6.hasNext()) {
            object5 = (DocFuncData)object6.next();
            for (Category object42 : object5.getCategories()) {
                object3 = this.groupedModels.get(object42);
                if (object3 == null) {
                    object3 = new HashMap<String, List<DocFuncData>>();
                    this.groupedModels.put(object42, (Map<String, List<DocFuncData>>)object3);
                }
                object2 = object3.getOrDefault(object5.getClassName(), new ArrayList());
                object2.add(object5);
                object3.put(object5.getClassName(), object2);
            }
        }
        object6 = new StringBuilder();
        object5 = new HashMap();
        Object object8 = object7.iterator();
        while (object8.hasNext()) {
            DocFuncData docFuncData = (DocFuncData)object8.next();
            Set set = object5.getOrDefault(docFuncData.getClassName(), new HashSet());
            object5.put(docFuncData.getClassName(), set);
            if (set.size() > 0) {
                logger.warn("Func name " + docFuncData.getClassName() + " has " + set.size() + " multiple category annotations:");
            }
            set.addAll(Arrays.asList(docFuncData.getCategories()));
            logger.info("Assigning " + docFuncData.getClassName() + " to categories " + set.toString());
        }
        object8 = new HashSet<Category>(){
            {
                this.add(Category.general);
            }
        };
        HashMap<Category, Map<String, List<DocFuncData>>> hashMap = new HashMap<Category, Map<String, List<DocFuncData>>>();
        Object object9 = object7.iterator();
        while (object9.hasNext()) {
            DocFuncData docFuncData = (DocFuncData)object9.next();
            object3 = (Set)object5.getOrDefault(docFuncData.getClassName(), object8);
            if (object3.size() == 0) {
                object3 = object8;
            }
            logger.info("looking up assignment for " + docFuncData.getClassName() + ":" + object3.toString());
            object2 = object3.iterator();
            while (object2.hasNext()) {
                Category category = (Category)object2.next();
                Map map = hashMap.getOrDefault(category, new HashMap());
                hashMap.put(category, map);
                object = map.getOrDefault(docFuncData.getClassName(), new ArrayList());
                map.put(docFuncData.getClassName(), object);
                object.add(docFuncData);
            }
        }
        this.groupedModels = hashMap;
        object9 = new HashMap();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
        try {
            for (Category category : Category.values()) {
                void var9_21;
                if (!this.groupedModels.keySet().contains(category)) continue;
                if (!this.baseFileName.isEmpty() && this.categories.equals(SPLIT)) {
                    Writer writer = object9.getOrDefault(category.toString(), new FileWriter(this.baseFileName + "_" + category.toString() + fileExtension));
                } else if (!this.baseFileName.isEmpty() && this.categories.equals(COMBINED)) {
                    Writer writer = object9.getOrDefault(this.baseFileName + fileExtension, new FileWriter(this.baseFileName));
                }
                object = this.writeCategoryDocs(category, this.groupedModels.get(category));
                var9_21.write((String)object);
                var9_21.flush();
            }
            for (Writer writer : object9.values()) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private String replacePatterns(String string) {
        string = string.replaceAll("<Object", "&lt;Object");
        string = string.replaceAll("Object>", "Object&gt;");
        string = string.replaceAll("java.lang.", "");
        string = string.replaceAll("^\\s*</?pre>\\s*\n", "\n```\n");
        string = string.replaceAll("(<p>|</p>| \n)+", "\n");
        string = string.replaceAll("<pre>", "`");
        string = string.replaceAll("</pre>", "`");
        string = string.replaceAll("\\{@link (.+?)}", "$1");
        string = string.replaceAll("(?m)@param .*\n", "");
        string = string.replaceAll("(?m)\n\n+", "\n\n");
        string = string.replaceAll("(?m)\\[]...:", "...");
        string = string.replaceAll("(?m)@see ", "See ");
        return string;
    }

    private String writeCategoryDocs(Category category, Map<String, List<DocFuncData>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        stringBuilder.append("# CATEGORY ").append(category).append("\n");
        for (String string : arrayList) {
            List<DocFuncData> list = map.get(string);
            stringBuilder.append("## ").append(string).append("\n\n");
            List list2 = list.stream().filter(docFuncData -> docFuncData.getClassJavadoc() != null && !docFuncData.getClassJavadoc().isEmpty()).collect(Collectors.toList());
            List list3 = list2.stream().map(DocFuncData::getClassJavadoc).map(String::trim).distinct().collect(Collectors.toList());
            if (list3.size() == 0) {
                logger.warn("There were no class docs found for types named " + string);
            }
            if (list3.size() > 1) {
                logger.warn("There were multiple class docs found for types named " + string);
            }
            if (list3.size() == 1) {
                Object object = (String)list3.get(0);
                object = this.parseHtmlToMarkdown((String)object);
                stringBuilder.append((String)object);
                if (!((String)object).endsWith("\n\n")) {
                    stringBuilder.append("\n");
                }
                if (!((String)object).endsWith("\n")) {
                    stringBuilder.append("\n");
                }
            }
            for (DocFuncData docFuncData2 : list) {
                List list4 = docFuncData2.getCtors();
                for (DocCtorData docCtorData : list4) {
                    stringBuilder.append("- ").append(docFuncData2.getInType()).append(" -> ");
                    stringBuilder.append(docFuncData2.getClassName());
                    stringBuilder.append("(");
                    stringBuilder.append(docCtorData.getArgs().entrySet().stream().map(entry -> (String)entry.getValue() + ": " + (String)entry.getKey()).collect(Collectors.joining(", ")));
                    stringBuilder.append(")");
                    stringBuilder.append(" -> ").append(docFuncData2.getOutType()).append("\n");
                    String string2 = docCtorData.getCtorJavaDoc();
                    if (!string2.isEmpty()) {
                        stringBuilder.append("  - *notes:* ").append(string2);
                    }
                    for (List list5 : docCtorData.getExamples()) {
                        stringBuilder.append("  - *ex:* `").append((String)list5.get(0)).append("`");
                        if (list5.size() > 1) {
                            stringBuilder.append(" - *").append((String)list5.get(1)).append("*");
                        }
                        stringBuilder.append("\n");
                    }
                }
            }
            stringBuilder.append("\n");
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private String parseHtmlToMarkdown(String string) {
        String string2 = FlexmarkHtmlParser.parse((String)string);
        return string2;
    }
}

