/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.apps.docsapp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.vladsch.flexmark.convert.html.FlexmarkHtmlParser;
import io.virtdata.annotations.Category;
import io.virtdata.apps.docsapp.FunctionDoc;
import io.virtdata.core.VirtDataDocs;
import io.virtdata.processors.DocCtorData;
import io.virtdata.processors.DocFuncData;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoDocsApp {
    private static final Logger logger = LoggerFactory.getLogger(AutoDocsApp.class);
    private static final String SPLIT = "split";
    private static final String COMBINED = "combined";
    private static final String ALL = "all";
    private static final String DEFAULT_FILE = "funcref";
    private static final String MARKDOWN = "markdown";
    private static final String JSON = "json";
    private Map<Category, Map<String, List<DocFuncData>>> groupedModels = new HashMap<Category, Map<String, List<DocFuncData>>>();
    private String baseFileName = "funcref";
    private String print = "all";
    private String categories = "split";
    private String format = "markdown";

    public static void main(String[] stringArray) {
        new AutoDocsApp().invoke(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    private void invoke(String[] stringArray) {
        Object object3;
        HashMap<String, Object> hashMap;
        Object object4;
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
        while (linkedList.peekFirst() != null) {
            object4 = linkedList.removeFirst();
            if (linkedList.peekFirst() == null) {
                throw new RuntimeException(AutoDocsApp.class.toString() + " expects args in param value couplets.");
            }
            hashMap = linkedList.removeFirst().toLowerCase();
            switch (object4) {
                case "output": {
                    this.baseFileName = hashMap;
                    break;
                }
                case "print": {
                    if (((String)((Object)hashMap)).equals(ALL) || ((String)((Object)hashMap)).equals("logs")) {
                        this.print = hashMap;
                    } else {
                        throw new InvalidParameterException("valid args for print: print all, print logs");
                    }
                }
                case "categories": {
                    if (!((String)((Object)hashMap)).equals(SPLIT) && !((String)((Object)hashMap)).equals(COMBINED)) {
                        throw new RuntimeException("categories must either be split, or combined.");
                    }
                    this.categories = hashMap;
                    break;
                }
                case "format": {
                    if (!((String)((Object)hashMap)).equals(MARKDOWN) && !((String)((Object)hashMap)).equals(JSON)) {
                        throw new RuntimeException("format must either be markdown, or json.");
                    }
                    this.format = hashMap;
                    break;
                }
            }
        }
        object4 = VirtDataDocs.getAllDocs();
        hashMap = object4.iterator();
        while (hashMap.hasNext()) {
            object3 = (DocFuncData)hashMap.next();
            for (Category object22 : object3.getCategories()) {
                Object object = this.groupedModels.get(object22);
                if (object == null) {
                    object = new HashMap<String, List<DocFuncData>>();
                    this.groupedModels.put(object22, (Map<String, List<DocFuncData>>)object);
                }
                List list = object.getOrDefault(object3.getClassName(), new ArrayList());
                list.add(object3);
                object.put((String)object3.getClassName(), (List<DocFuncData>)list);
            }
        }
        hashMap = new HashMap<String, Object>();
        object3 = object4.iterator();
        while (object3.hasNext()) {
            DocFuncData docFuncData = (DocFuncData)object3.next();
            Set set = hashMap.getOrDefault(docFuncData.getClassName(), new HashSet());
            hashMap.put(docFuncData.getClassName(), set);
            if (set.size() > 0) {
                logger.warn("Func name " + docFuncData.getClassName() + " has " + set.size() + " multiple category annotations:");
            }
            set.addAll(Arrays.asList(docFuncData.getCategories()));
            logger.info("Assigning " + docFuncData.getClassName() + " to categories " + set.toString());
        }
        object3 = new HashSet<Category>(){
            {
                this.add(Category.general);
            }
        };
        HashMap<Category, Map<String, List<DocFuncData>>> hashMap2 = new HashMap<Category, Map<String, List<DocFuncData>>>();
        Object object5 = object4.iterator();
        while (object5.hasNext()) {
            void var9_22;
            DocFuncData docFuncData = (DocFuncData)object5.next();
            Set set = (Set)hashMap.getOrDefault(docFuncData.getClassName(), object3);
            if (set.size() == 0) {
                Object object = object3;
            }
            logger.info("looking up assignment for " + docFuncData.getClassName() + ":" + var9_22.toString());
            for (List list : var9_22) {
                Map map = hashMap2.getOrDefault(list, new HashMap());
                hashMap2.put((Category)list, map);
                List list2 = map.getOrDefault(docFuncData.getClassName(), new ArrayList());
                map.put(docFuncData.getClassName(), list2);
                list2.add(docFuncData);
            }
        }
        this.groupedModels = hashMap2;
        object5 = new HashMap();
        Writer writer = new OutputStreamWriter(System.out);
        try {
            String string = this.format.equals(MARKDOWN) ? ".md" : ".json";
            for (Category category : Category.values()) {
                if (!this.groupedModels.keySet().contains(category)) continue;
                if (!this.baseFileName.isEmpty() && this.categories.equals(SPLIT)) {
                    writer = object5.getOrDefault(category.toString(), new FileWriter(this.baseFileName + "_" + category.toString() + string));
                } else if (!this.baseFileName.isEmpty() && this.categories.equals(COMBINED)) {
                    writer = object5.getOrDefault(this.baseFileName + string, new FileWriter(this.baseFileName));
                }
                String string2 = this.writeCategoryDocs(category, this.groupedModels.get(category));
                writer.write(string2);
                ((Writer)writer).flush();
            }
            for (Writer writer2 : object5.values()) {
                writer2.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private String writeCategoryDocs(Category category, Map<String, List<DocFuncData>> map) {
        Object object;
        List list;
        List list2;
        List<Object> list3;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(map.size());
        for (String string : arrayList) {
            object2 = new FunctionDoc(string);
            list3 = map.get(string);
            list2 = list3.stream().filter(docFuncData -> docFuncData.getClassJavadoc() != null && !docFuncData.getClassJavadoc().isEmpty()).collect(Collectors.toList());
            list = list2.stream().map(DocFuncData::getClassJavadoc).map(String::trim).distinct().collect(Collectors.toList());
            if (list.size() == 0) {
                logger.warn("There were no class docs found for types named " + string);
            }
            if (list.size() > 1) {
                logger.warn("There were multiple class docs found for types named " + string);
            }
            if (list.size() == 1) {
                object = (String)list.get(0);
                object = this.parseHtmlToMarkdown((String)object);
                stringBuilder.append((String)object);
                if (!((String)object).endsWith("\n")) {
                    object = (String)object + "\n";
                }
                if (!((String)object).endsWith("\n\n")) {
                    object = (String)object + "\n";
                }
                ((FunctionDoc)object2).setClassDocs((String)object);
            }
            for (Object object3 : list3) {
                ((FunctionDoc)object2).addCategories(object3.getCategories());
                for (DocCtorData docCtorData : object3.getCtors()) {
                    ((FunctionDoc)object2).addCtor(docCtorData);
                }
            }
            arrayList2.add(object2);
        }
        if (this.format.equals(MARKDOWN)) {
            stringBuilder.append("# CATEGORY ").append(category).append("\n");
            for (String string : arrayList) {
                object2 = map.get(string);
                stringBuilder.append("## ").append(string).append("\n\n");
                list3 = object2.stream().filter(docFuncData -> docFuncData.getClassJavadoc() != null && !docFuncData.getClassJavadoc().isEmpty()).collect(Collectors.toList());
                list2 = list3.stream().map(DocFuncData::getClassJavadoc).map(String::trim).distinct().collect(Collectors.toList());
                if (list2.size() == 0) {
                    logger.warn("There were no class docs found for types named " + string);
                }
                if (list2.size() > 1) {
                    logger.warn("There were multiple class docs found for types named " + string);
                }
                if (list2.size() == 1) {
                    list = (String)list2.get(0);
                    list = this.parseHtmlToMarkdown((String)((Object)list));
                    stringBuilder.append((String)((Object)list));
                    if (!((String)((Object)list)).endsWith("\n\n")) {
                        stringBuilder.append("\n");
                    }
                    if (!((String)((Object)list)).endsWith("\n")) {
                        stringBuilder.append("\n");
                    }
                }
                list = object2.iterator();
                while (list.hasNext()) {
                    Object object3;
                    object = (DocFuncData)list.next();
                    object3 = object.getCtors();
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        DocCtorData docCtorData;
                        docCtorData = (DocCtorData)iterator.next();
                        stringBuilder.append("- ").append(object.getInType()).append(" -> ");
                        stringBuilder.append(object.getClassName());
                        stringBuilder.append("(");
                        stringBuilder.append(docCtorData.getArgs().entrySet().stream().map(entry -> (String)entry.getValue() + ": " + (String)entry.getKey()).collect(Collectors.joining(", ")));
                        stringBuilder.append(")");
                        stringBuilder.append(" -> ").append(object.getOutType()).append("\n");
                        String string2 = docCtorData.getCtorJavaDoc();
                        if (!string2.isEmpty()) {
                            stringBuilder.append("  - *notes:* ").append(string2);
                        }
                        for (List list4 : docCtorData.getExamples()) {
                            stringBuilder.append("  - *ex:* `").append((String)list4.get(0)).append("`");
                            if (list4.size() > 1) {
                                stringBuilder.append(" - *").append((String)list4.get(1)).append("*");
                            }
                            stringBuilder.append("\n");
                        }
                    }
                }
                stringBuilder.append("\n");
                stringBuilder.append("\n");
            }
        } else if (this.format.equals(JSON)) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            stringBuilder.append(gson.toJson(arrayList2));
        }
        return stringBuilder.toString();
    }

    private String parseHtmlToMarkdown(String string) {
        String string2 = FlexmarkHtmlParser.parse((String)string);
        return string2;
    }
}

