/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.apps.valuesapp;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class IndexedThreadFactory
implements ThreadFactory {
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private String name = Thread.currentThread().getName() + "-factory";
    private AtomicInteger threadIndexer = new AtomicInteger(0);

    public IndexedThreadFactory(String string, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.name = string;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public IndexedThread newThread(Runnable runnable) {
        int n = this.threadIndexer.incrementAndGet();
        IndexedThread indexedThread = new IndexedThread(n, runnable);
        indexedThread.setName(this.name + String.format(":%03d", n));
        indexedThread.setMetricName(indexedThread.getName().split(":")[0].split("/")[0]);
        if (this.uncaughtExceptionHandler != null) {
            indexedThread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        }
        return indexedThread;
    }

    public class IndexedThread
    extends Thread {
        private int threadIndex;
        private String metricName;

        public IndexedThread(int n, Runnable runnable) {
            super(runnable);
            this.metricName = "default-name-" + Thread.currentThread().getName();
            this.threadIndex = n;
        }

        public int getThreadIndex() {
            return this.threadIndex;
        }

        public void setMetricName(String string) {
            this.metricName = string;
        }

        public String getMetricName() {
            return this.metricName;
        }
    }
}

