/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.apps.valuesapp;

import io.virtdata.apps.valuesapp.RunData;
import io.virtdata.apps.valuesapp.ValuesCheckerCoordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesCheckerApp {
    private static final Logger logger = LoggerFactory.getLogger(ValuesCheckerApp.class);

    public static void main(String[] stringArray) {
        if (stringArray.length < 5) {
            System.out.println("ARGS: 'specifier' threads bufsize start end");
            System.out.println("example: 'timeuuid()' 100 1000 0 10000");
            System.out.println(" specifier: A VirtData function specifier.");
            System.out.println(" threads: The number of concurrent threads to run.");
            System.out.println(" bufsize: The number of cycles to give each thread at a time.");
            System.out.println(" start: The start cycle for the test, inclusive.");
            System.out.println(" end: The end cycle for the test, exclusive.");
            System.exit(2);
        }
        String string = stringArray[0];
        int n = Integer.valueOf(stringArray[1]);
        int n2 = Integer.valueOf(stringArray[2]);
        long l = Long.valueOf(stringArray[3]);
        long l2 = Long.valueOf(stringArray[4]);
        boolean bl = false;
        if (stringArray.length == 6) {
            bl = stringArray[5].toLowerCase().equals("isolated") || stringArray[5].toLowerCase().equals("true");
        }
        ValuesCheckerCoordinator valuesCheckerCoordinator = new ValuesCheckerCoordinator(string, n, n2, l, l2, bl);
        if (!bl) {
            logger.warn("You are testing functions which are not intended to be thread-safe in a non-threadsafe way.");
            logger.warn("This is only advisable if you are doing development against the core libraries.");
            logger.warn("Results may vary.");
        }
        try {
            RunData runData = valuesCheckerCoordinator.call();
            System.out.println(runData.toString());
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(2);
        }
    }
}

