/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.apps.valuesapp;

import io.virtdata.api.DataMapper;
import io.virtdata.apps.valuesapp.IndexedThreadFactory;
import io.virtdata.apps.valuesapp.RunData;
import io.virtdata.apps.valuesapp.ValuesCheckerExceptionHandler;
import io.virtdata.apps.valuesapp.ValuesCheckerRunnable;
import io.virtdata.core.VirtData;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesCheckerCoordinator
implements Callable<RunData> {
    private static final Logger logger = LoggerFactory.getLogger(ValuesCheckerCoordinator.class);
    private final String specifier;
    private final int threads;
    private final int bufsize;
    private final long end;
    private final long start;
    private final boolean isolated;
    private final ReentrantLock lock;
    private final Condition goTime;
    private final ConcurrentLinkedDeque<Throwable> errors = new ConcurrentLinkedDeque();
    private final ConcurrentLinkedQueue<Integer> readyQueue = new ConcurrentLinkedQueue();
    ExecutorService pool;
    private long genTimeAccumulator = 0L;
    private long cmpTimeAccumulator = 0L;

    public ValuesCheckerCoordinator(String string, int n, int n2, long l, long l2, boolean bl) {
        this.specifier = string;
        this.threads = n;
        this.bufsize = n2;
        this.start = l;
        this.end = l2;
        this.isolated = bl;
        this.lock = new ReentrantLock();
        this.goTime = this.lock.newCondition();
    }

    public void run() {
        this.testConcurrentValues(this.threads, this.start, this.end, this.specifier);
        if (this.errors.size() > 0) {
            for (Throwable throwable : this.errors) {
                System.out.println(throwable.getMessage());
            }
            throw new RuntimeException("Errors in verification: " + this.errors);
        }
    }

    private void testConcurrentValues(int n, long l, long l2, String string) {
        Object object;
        DataMapper dataMapper = (DataMapper)VirtData.getOptionalMapper((String)this.specifier).orElseThrow(() -> new RuntimeException("Unable to map function for specifier: " + this.specifier));
        CopyOnWriteArrayList<Object> copyOnWriteArrayList = new CopyOnWriteArrayList<Object>();
        ValuesCheckerExceptionHandler valuesCheckerExceptionHandler = new ValuesCheckerExceptionHandler(this);
        IndexedThreadFactory indexedThreadFactory = new IndexedThreadFactory("values-checker", valuesCheckerExceptionHandler);
        this.pool = Executors.newFixedThreadPool(n, indexedThreadFactory);
        logger.info("Checking [{}..{}) in chunks of {}", new Object[]{l, l2, this.bufsize});
        if (!this.isolated) {
            logger.debug("Sharing data mapper, only expect success for explicitly thread-safe generators.");
        }
        for (int i = 0; i < n; ++i) {
            ValuesCheckerRunnable valuesCheckerRunnable;
            if (this.isolated) {
                valuesCheckerRunnable = new ValuesCheckerRunnable(l, l2, this.bufsize, i, string, null, this.readyQueue, this.goTime, this.lock, copyOnWriteArrayList);
            } else {
                object = (DataMapper)VirtData.getOptionalMapper((String)string).orElseThrow(() -> new RuntimeException("Unable to map function for specifier: " + this.specifier));
                valuesCheckerRunnable = new ValuesCheckerRunnable(l, l2, this.bufsize, i, null, (DataMapper<?>)object, this.readyQueue, this.goTime, this.lock, (List<Object>)copyOnWriteArrayList);
            }
            this.pool.execute(valuesCheckerRunnable);
        }
        logger.info("starting generation loops...");
        for (long i = 0L; i < l2 - l; i += (long)this.bufsize) {
            object = "[" + i + ".." + (i + (long)this.bufsize) + ")";
            long l3 = System.nanoTime();
            this.coordinateFor("generation start " + (String)object);
            this.throwInjectedExceptions();
            this.coordinateFor("generation complete " + (String)object);
            long l4 = System.nanoTime();
            long l5 = l4 - l3;
            this.genTimeAccumulator += l5;
            this.throwInjectedExceptions();
            System.out.print(".");
            System.out.flush();
            long l6 = System.nanoTime();
            this.coordinateFor("verification start " + (String)object);
            this.throwInjectedExceptions();
            this.coordinateFor("verification complete " + (String)object);
            long l7 = System.nanoTime();
            long l8 = l7 - l6;
            this.cmpTimeAccumulator += l8;
            this.throwInjectedExceptions();
            System.out.print(".");
            System.out.flush();
        }
        System.out.println("\n");
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(60000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private synchronized void throwInjectedExceptions() {
        if (this.errors.peekFirst() != null) {
            int n = 0;
            for (Throwable throwable : this.errors) {
                System.out.print("EXCEPTION " + n++ + ": ");
                System.out.println(throwable.getMessage());
            }
            throw new RuntimeException(this.errors.peekFirst());
        }
    }

    synchronized void handleException(Thread thread, Throwable throwable) {
        this.errors.add(throwable);
        if (this.pool != null) {
            this.pool.shutdownNow();
        }
    }

    private void coordinateFor(String string) {
        logger.trace("coordinating " + this.threads + " threads for " + string);
        try {
            long l = 1L;
            while (this.readyQueue.size() < this.threads) {
                Thread.sleep(l);
                l = Math.min(1024L, l * 2L);
                this.throwInjectedExceptions();
            }
            this.readyQueue.clear();
            this.lock.lock();
            this.goTime.signalAll();
        }
        catch (Exception exception) {
            logger.error("Error while signaling threads: " + exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public RunData call() throws Exception {
        this.run();
        return new RunData(this.specifier, this.threads, this.start, this.end, this.bufsize, this.isolated, (double)this.genTimeAccumulator / 1000000.0, (double)this.cmpTimeAccumulator / 1000000.0);
    }
}

