/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.apps.valuesapp;

import io.virtdata.api.DataMapper;
import io.virtdata.core.VirtData;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuesCheckerRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ValuesCheckerRunnable.class);
    private final Condition goTime;
    private final Lock lock;
    private final long start;
    private final long end;
    private final List<Object> expected;
    private final DataMapper mapper;
    private final int threadNum;
    private final ConcurrentLinkedQueue<Integer> readyQueue;
    private int bufsize;

    public ValuesCheckerRunnable(long l, long l2, int n, int n2, String string, DataMapper<?> dataMapper, ConcurrentLinkedQueue<Integer> concurrentLinkedQueue, Condition condition, Lock lock, List<Object> list) {
        this.start = l;
        this.end = l2;
        this.bufsize = n;
        this.threadNum = n2;
        this.readyQueue = concurrentLinkedQueue;
        this.expected = list;
        this.goTime = condition;
        this.lock = lock;
        this.mapper = dataMapper != null ? dataMapper : (DataMapper)VirtData.getOptionalMapper((String)string).orElseThrow(() -> new RuntimeException("unable to resolve mapper for " + string));
    }

    @Override
    public void run() {
        Object[] objectArray = new Object[this.bufsize];
        for (long i = this.start; i < this.end; i += (long)this.bufsize) {
            int n;
            String string = "t:" + this.threadNum + " [" + i + ".." + (i + (long)this.bufsize) + ")";
            this.synchronizeFor("generation start " + string);
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = this.mapper.get((long)n + i);
            }
            if (this.threadNum == 0) {
                logger.trace("Thread " + this.threadNum + " putting values into comparable array before acking");
                this.expected.clear();
                this.expected.addAll(Arrays.asList(objectArray));
                if (System.getProperties().containsKey("PRINTVALUES")) {
                    for (n = 0; n < objectArray.length; ++n) {
                        System.out.println(this.start + (long)n + "->" + objectArray[n]);
                    }
                }
            }
            this.synchronizeFor("generation complete " + string);
            this.synchronizeFor("verification " + string);
            for (n = 0; n < this.expected.size(); ++n) {
                if (this.expected.get(n).equals(objectArray[n])) continue;
                String string2 = "Value differs: iteration: " + ((long)n + i) + " expected:'" + this.expected.get(n) + "' actual:'" + objectArray[n] + "'";
                throw new RuntimeException(string2);
            }
            this.synchronizeFor("verification complete" + string);
        }
    }

    private void synchronizeFor(String string) {
        try {
            this.lock.lock();
            this.readyQueue.add(this.threadNum);
            logger.trace("awaiting signal for " + string);
            this.goTime.await();
        }
        catch (Throwable throwable) {
            System.out.println("error while synchronizing: " + throwable.getMessage());
            throw new RuntimeException(throwable);
        }
        finally {
            this.lock.unlock();
        }
    }
}

